/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOAuthFlows;
import org.openapitools.openapidiff.core.model.ChangedSecuritySchemeScopes;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedSecurityScheme
implements ComposedChanged {
    private SecurityScheme oldSecurityScheme;
    private SecurityScheme newSecurityScheme;
    private final DiffContext context;
    private boolean changedType;
    private boolean changedIn;
    private boolean changedScheme;
    private boolean changedBearerFormat;
    private boolean changedOpenIdConnectUrl;
    private ChangedSecuritySchemeScopes changedScopes;
    private ChangedMetadata description;
    private ChangedOAuthFlows oAuthFlows;
    private ChangedExtensions extensions;

    public ChangedSecurityScheme(SecurityScheme oldSecurityScheme, SecurityScheme newSecurityScheme, DiffContext context) {
        this.oldSecurityScheme = oldSecurityScheme;
        this.newSecurityScheme = newSecurityScheme;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.description, this.oAuthFlows, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (!(this.changedType || this.changedIn || this.changedScheme || this.changedBearerFormat || this.changedOpenIdConnectUrl || this.changedScopes != null && !this.changedScopes.isUnchanged())) {
            return DiffResult.NO_CHANGES;
        }
        if (this.changedBearerFormat && BackwardIncompatibleProp.SECURITY_SCHEME_BEARER_FORMAT_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changedOpenIdConnectUrl && BackwardIncompatibleProp.SECURITY_SCHEME_OPENIDCONNECT_URL_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changedScheme && BackwardIncompatibleProp.SECURITY_SCHEME_SCHEME_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changedScopes != null && !this.changedScopes.getIncreased().isEmpty() && BackwardIncompatibleProp.SECURITY_SCHEME_SCOPES_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.changedIn || this.changedType) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public SecurityScheme getOldSecurityScheme() {
        return this.oldSecurityScheme;
    }

    public SecurityScheme getNewSecurityScheme() {
        return this.newSecurityScheme;
    }

    public boolean isChangedType() {
        return this.changedType;
    }

    public boolean isChangedIn() {
        return this.changedIn;
    }

    public boolean isChangedScheme() {
        return this.changedScheme;
    }

    public boolean isChangedBearerFormat() {
        return this.changedBearerFormat;
    }

    public boolean isChangedOpenIdConnectUrl() {
        return this.changedOpenIdConnectUrl;
    }

    public ChangedSecuritySchemeScopes getChangedScopes() {
        return this.changedScopes;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedOAuthFlows getOAuthFlows() {
        return this.oAuthFlows;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedSecurityScheme setOldSecurityScheme(SecurityScheme oldSecurityScheme) {
        this.oldSecurityScheme = oldSecurityScheme;
        return this;
    }

    public ChangedSecurityScheme setNewSecurityScheme(SecurityScheme newSecurityScheme) {
        this.newSecurityScheme = newSecurityScheme;
        return this;
    }

    public ChangedSecurityScheme setChangedType(boolean changedType) {
        this.changedType = changedType;
        return this;
    }

    public ChangedSecurityScheme setChangedIn(boolean changedIn) {
        this.changedIn = changedIn;
        return this;
    }

    public ChangedSecurityScheme setChangedScheme(boolean changedScheme) {
        this.changedScheme = changedScheme;
        return this;
    }

    public ChangedSecurityScheme setChangedBearerFormat(boolean changedBearerFormat) {
        this.changedBearerFormat = changedBearerFormat;
        return this;
    }

    public ChangedSecurityScheme setChangedOpenIdConnectUrl(boolean changedOpenIdConnectUrl) {
        this.changedOpenIdConnectUrl = changedOpenIdConnectUrl;
        return this;
    }

    public ChangedSecurityScheme setChangedScopes(ChangedSecuritySchemeScopes changedScopes) {
        this.changedScopes = changedScopes;
        return this;
    }

    public ChangedSecurityScheme setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedSecurityScheme setOAuthFlows(ChangedOAuthFlows oAuthFlows) {
        this.oAuthFlows = oAuthFlows;
        return this;
    }

    public ChangedSecurityScheme setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedSecurityScheme that = (ChangedSecurityScheme)o;
        return this.changedType == that.changedType && this.changedIn == that.changedIn && this.changedScheme == that.changedScheme && this.changedBearerFormat == that.changedBearerFormat && this.changedOpenIdConnectUrl == that.changedOpenIdConnectUrl && Objects.equals(this.oldSecurityScheme, that.oldSecurityScheme) && Objects.equals(this.newSecurityScheme, that.newSecurityScheme) && Objects.equals(this.changedScopes, that.changedScopes) && Objects.equals(this.description, that.description) && Objects.equals(this.oAuthFlows, that.oAuthFlows) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldSecurityScheme, this.newSecurityScheme, this.changedType, this.changedIn, this.changedScheme, this.changedBearerFormat, this.changedOpenIdConnectUrl, this.changedScopes, this.description, this.oAuthFlows, this.extensions);
    }

    public String toString() {
        return "ChangedSecurityScheme(oldSecurityScheme=" + this.getOldSecurityScheme() + ", newSecurityScheme=" + this.getNewSecurityScheme() + ", changedType=" + this.isChangedType() + ", changedIn=" + this.isChangedIn() + ", changedScheme=" + this.isChangedScheme() + ", changedBearerFormat=" + this.isChangedBearerFormat() + ", changedOpenIdConnectUrl=" + this.isChangedOpenIdConnectUrl() + ", changedScopes=" + this.getChangedScopes() + ", description=" + this.getDescription() + ", oAuthFlows=" + this.getOAuthFlows() + ", extensions=" + this.getExtensions() + ")";
    }
}

