/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.keycloak.theme.TemplatingUtil;

public class MessageFormatterMethod
implements TemplateMethodModelEx {
    private final Properties messages;
    private final Locale locale;

    public MessageFormatterMethod(Locale locale, Properties messages) {
        this.locale = locale;
        this.messages = messages;
    }

    public MessageFormatterMethod(Locale locale, Map<Object, Object> messages) {
        this.locale = locale;
        this.messages = new Properties();
        this.messages.putAll((Map<?, ?>)Optional.ofNullable(messages).orElse(Map.of()));
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() >= 1) {
            List<Object> resolved = this.resolve(list.subList(1, list.size()));
            String key = list.get(0).toString();
            String value = this.messages.getOrDefault((Object)key, key).toString();
            value = (String)this.resolve(List.of(value)).get(0);
            return new MessageFormat(value, this.locale).format(resolved.toArray());
        }
        return null;
    }

    private List<Object> resolve(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof SimpleScalar) {
                SimpleScalar scalar = (SimpleScalar)item;
                item = scalar.getAsString();
            } else if (item instanceof SimpleNumber) {
                SimpleNumber number = (SimpleNumber)item;
                item = number.getAsNumber();
            } else if (item instanceof SimpleDate) {
                SimpleDate date = (SimpleDate)item;
                item = date.getAsDate();
            }
            if (item instanceof String) {
                String string = (String)item;
                result.add(TemplatingUtil.resolveVariables(string, this.messages));
                continue;
            }
            result.add(item);
        }
        return result;
    }
}

