/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public class DurationConverter {
    private static final String PERIOD = "P";
    private static final String PERIOD_OF_TIME = "PT";
    public static final Pattern DIGITS = Pattern.compile("^[-+]?\\d+$");
    private static final Pattern DIGITS_AND_UNIT = Pattern.compile("^(?:[-+]?\\d+(?:\\.\\d+)?(?i)[hms])+$");
    private static final Pattern DAYS = Pattern.compile("^[-+]?\\d+(?i)d$");
    private static final Pattern MILLIS = Pattern.compile("^[-+]?\\d+(?i)ms$");

    public static Duration parseDuration(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (DIGITS.asPredicate().test(value)) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        if (MILLIS.asPredicate().test(value)) {
            return Duration.ofMillis(Long.parseLong(value.substring(0, value.length() - 2)));
        }
        try {
            if (DIGITS_AND_UNIT.asPredicate().test(value)) {
                return Duration.parse(PERIOD_OF_TIME + value);
            }
            if (DAYS.asPredicate().test(value)) {
                return Duration.parse(PERIOD + value);
            }
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isPositiveDuration(String value) {
        Duration duration = DurationConverter.parseDuration(value);
        return duration != null && !duration.isNegative() && !duration.isZero();
    }
}

