/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.user;

public class SynchronizationResult {
    private boolean ignored;
    private int added;
    private int updated;
    private int removed;
    private int failed;

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public int getAdded() {
        return this.added;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    public int getUpdated() {
        return this.updated;
    }

    public void setUpdated(int updated) {
        this.updated = updated;
    }

    public int getRemoved() {
        return this.removed;
    }

    public void setRemoved(int removed) {
        this.removed = removed;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public void increaseAdded() {
        ++this.added;
    }

    public void increaseUpdated() {
        ++this.updated;
    }

    public void increaseRemoved() {
        ++this.removed;
    }

    public void increaseFailed() {
        ++this.failed;
    }

    public void add(SynchronizationResult other) {
        this.added += other.added;
        this.updated += other.updated;
        this.removed += other.removed;
        this.failed += other.failed;
    }

    public String getStatus() {
        if (this.ignored) {
            return "Synchronization ignored as it's already in progress";
        }
        Object status = String.format("%d imported users, %d updated users", this.added, this.updated);
        if (this.removed > 0) {
            status = (String)status + String.format(", %d removed users", this.removed);
        }
        if (this.failed != 0) {
            status = (String)status + String.format(", %d users failed sync! See server log for more details", this.failed);
        }
        return status;
    }

    public String toString() {
        return String.format("UserFederationSyncResult [ %s ]", this.getStatus());
    }

    public static SynchronizationResult empty() {
        return new SynchronizationResult();
    }

    public static SynchronizationResult ignored() {
        SynchronizationResult result = new SynchronizationResult();
        result.setIgnored(true);
        return result;
    }
}

