/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.All;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.impl.Instances;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class ListProvider
implements InjectableReferenceProvider<List<?>> {
    private final Type requiredType;
    private final Type injectionPointType;
    private final Set<Annotation> qualifiers;
    private final InjectableBean<?> targetBean;
    private final Set<Annotation> annotations;
    private final Member javaMember;
    private final int position;
    private final boolean isTransient;
    private final boolean needsInstanceHandle;

    public ListProvider(Type requiredType, Type injectionPointType, Set<Annotation> qualifiers, InjectableBean<?> targetBean, Set<Annotation> annotations, Member javaMember, int position, boolean isTransient, boolean needsInstanceHandle) {
        this.requiredType = requiredType;
        this.injectionPointType = injectionPointType;
        this.qualifiers = qualifiers;
        this.qualifiers.remove(All.Literal.INSTANCE);
        this.targetBean = targetBean;
        this.annotations = annotations;
        this.javaMember = javaMember;
        this.position = position;
        this.isTransient = isTransient;
        this.needsInstanceHandle = needsInstanceHandle;
    }

    @Override
    public List<?> get(CreationalContext<List<?>> creationalContext) {
        if (this.needsInstanceHandle) {
            return Instances.listOfHandles(this.targetBean, this.injectionPointType, this.requiredType, this.qualifiers, creationalContext, this.annotations, this.javaMember, this.position, this.isTransient);
        }
        return Instances.listOf(this.targetBean, this.injectionPointType, this.requiredType, this.qualifiers, creationalContext, this.annotations, this.javaMember, this.position, this.isTransient);
    }
}

