/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;

public abstract class Disclosable {
    private final SdJwtSalt salt;

    abstract Object[] toArray();

    protected Disclosable(SdJwtSalt salt) {
        this.salt = Objects.requireNonNull(salt, "Disclosure always requires a salt must not be null");
    }

    public SdJwtSalt getSalt() {
        return this.salt;
    }

    public String getSaltAsString() {
        return this.salt.toString();
    }

    public String toJson() {
        try {
            return SdJwtUtils.printJsonArray(this.toArray());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDisclosureString() {
        String json = this.toJson();
        return SdJwtUtils.encodeNoPad(json.getBytes());
    }

    public String getDisclosureDigest(String hashAlg) {
        return SdJwtUtils.encodeNoPad(HashUtils.hash(hashAlg, this.getDisclosureString().getBytes()));
    }

    public String toString() {
        return this.getDisclosureString();
    }
}

