/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class UniCreateFromPublisher<T>
extends AbstractUni<T> {
    private final Flow.Publisher<? extends T> publisher;

    public UniCreateFromPublisher(Flow.Publisher<? extends T> publisher) {
        this.publisher = ParameterValidation.nonNull(publisher, "publisher");
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        new PublisherSubscriber<T>(this.publisher, subscriber).forward();
    }

    private static class PublisherSubscriber<T>
    implements UniSubscription,
    Flow.Subscriber<T>,
    ContextSupport {
        private final UniSubscriber<? super T> subscriber;
        private final Flow.Publisher<? extends T> publisher;
        private volatile Flow.Subscription subscription;
        private static final AtomicReferenceFieldUpdater<PublisherSubscriber, Flow.Subscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PublisherSubscriber.class, Flow.Subscription.class, "subscription");

        private PublisherSubscriber(Flow.Publisher<? extends T> publisher, UniSubscriber<? super T> subscriber) {
            this.subscriber = subscriber;
            this.publisher = publisher;
        }

        private void forward() {
            this.subscriber.onSubscribe(this);
            Flow.Subscriber<? extends T> sub = Infrastructure.onMultiSubscription(this.publisher, this);
            this.publisher.subscribe(sub);
        }

        @Override
        public void cancel() {
            Flow.Subscription old = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
            if (old != null) {
                old.cancel();
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription sub) {
            if (SUBSCRIPTION_UPDATER.compareAndSet(this, null, sub)) {
                sub.request(1L);
            } else {
                sub.cancel();
            }
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                sub.cancel();
                this.subscriber.onItem(item);
            }
        }

        @Override
        public void onError(Throwable failure) {
            Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                this.subscriber.onFailure(failure);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
            if (sub != EmptyUniSubscription.CANCELLED) {
                this.subscriber.onItem(null);
            }
        }

        @Override
        public Context context() {
            return this.subscriber.context();
        }
    }
}

