/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.util.JsonSerialization;

public class IdpLinkAction
implements RequiredActionProvider,
RequiredActionFactory {
    protected static final Logger logger = Logger.getLogger(IdpLinkAction.class);
    public static final String PROVIDER_ID = "idp_link";
    public static final String KC_ACTION_LINKING_IDENTITY_PROVIDER = "kc_action_linking_identity_provider";
    public static final String IDP_LINK_STATUS = "idp_link_status";
    public static final String IDP_LINK_ERROR = "idp_link_error";

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        RoleModel linkRole;
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        ClientModel client = authSession.getClient();
        EventBuilder event = context.getEvent().clone();
        event.event(EventType.FEDERATED_IDENTITY_LINK);
        String identityProviderAlias = authSession.getClientNote("kc_action_parameter");
        if (identityProviderAlias == null) {
            event.error("unknown_identity_provider");
            context.ignore();
            return;
        }
        event.detail("identity_provider", identityProviderAlias);
        IdentityProviderModel identityProviderModel = session.identityProviders().getByAlias(identityProviderAlias);
        if (identityProviderModel == null) {
            event.error("unknown_identity_provider");
            context.ignore();
            return;
        }
        ClientModel accountService = realm.getClientByClientId("account");
        RoleModel manageAccountRole = accountService.getRole("manage-account");
        if (!(user.hasRole(manageAccountRole) && client.hasScope(manageAccountRole) || user.hasRole(linkRole = accountService.getRole("manage-account-links")) && client.hasScope(linkRole))) {
            event.error("not_allowed");
            context.ignore();
            return;
        }
        String idpDisplayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)session, (IdentityProviderModel)identityProviderModel);
        Response challenge = context.form().setAttribute("idpDisplayName", (Object)idpDisplayName).createForm("link-idp-action.ftl");
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        ClientModel client = authSession.getClient();
        if (!Boolean.parseBoolean(authSession.getAuthNote(KC_ACTION_LINKING_IDENTITY_PROVIDER))) {
            String identityProviderAlias = authSession.getClientNote("kc_action_parameter");
            ClientSessionCode<AuthenticationSessionModel> clientSessionCode = new ClientSessionCode<AuthenticationSessionModel>(session, realm, authSession);
            clientSessionCode.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
            String noteValue = authSession.getParentSession().getId() + client.getClientId() + identityProviderAlias;
            authSession.setAuthNote("LINKING_IDENTITY_PROVIDER", noteValue);
            authSession.setAuthNote(KC_ACTION_LINKING_IDENTITY_PROVIDER, "true");
            IdentityBrokerService brokerService = new IdentityBrokerService(session);
            Response response = brokerService.performClientInitiatedAccountLogin(identityProviderAlias, clientSessionCode);
            context.challenge(response);
        } else {
            EventBuilder event = context.getEvent();
            event.event(EventType.FEDERATED_IDENTITY_LINK);
            String statusNote = authSession.getAuthNote(IDP_LINK_STATUS);
            if (statusNote == null) {
                this.removeAuthNotes(authSession);
                logger.warn((Object)"Not found IDP_LINK_STATUS even if redirect to IDP was already triggered");
                context.failure("invalid_request");
                return;
            }
            RequiredActionContext.KcActionStatus status = RequiredActionContext.KcActionStatus.valueOf((String)statusNote);
            switch (status) {
                case SUCCESS: {
                    context.success();
                    break;
                }
                case CANCELLED: {
                    context.cancel();
                    break;
                }
                case ERROR: {
                    String error = authSession.getAuthNote(IDP_LINK_ERROR);
                    this.errorPage(context, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown status in the note idp_link_status: " + String.valueOf(status));
                }
            }
            this.removeAuthNotes(authSession);
        }
    }

    private void removeAuthNotes(AuthenticationSessionModel authSession) {
        authSession.removeAuthNote(KC_ACTION_LINKING_IDENTITY_PROVIDER);
        authSession.removeAuthNote(IDP_LINK_STATUS);
        authSession.removeAuthNote(IDP_LINK_ERROR);
    }

    private void errorPage(RequiredActionContext context, String serializedError) {
        FormMessage formMessage;
        try {
            formMessage = (FormMessage)JsonSerialization.readValue((String)serializedError, FormMessage.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error when deserialization of error: " + serializedError);
        }
        Response response = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setAuthenticationSession(context.getAuthenticationSession()).setUser(context.getUser()).setErrors(Collections.singletonList(formMessage)).createErrorPage(Response.Status.BAD_REQUEST);
        context.getEvent().error(formMessage.getMessage());
        context.challenge(response);
    }

    public String getDisplayText() {
        return "Linking Identity Provider";
    }

    public void close() {
    }
}

