/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.env.internal.ExtractedDatabaseMetaDataImpl;
import org.hibernate.engine.jdbc.env.internal.LobCreatorBuilderImpl;
import org.hibernate.engine.jdbc.env.internal.QualifiedObjectNameFormatterStandardImpl;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.LobCreatorBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.exception.internal.SQLExceptionTypeDelegate;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.internal.StandardSQLExceptionConverter;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.jboss.logging.Logger;

public class JdbcEnvironmentImpl
implements JdbcEnvironment {
    private static final Logger log = Logger.getLogger(JdbcEnvironmentImpl.class);
    private final Dialect dialect;
    private final SqlAstTranslatorFactory sqlAstTranslatorFactory;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final ExtractedDatabaseMetaData extractedMetaDataSupport;
    private final Identifier currentCatalog;
    private final Identifier currentSchema;
    private final IdentifierHelper identifierHelper;
    private final QualifiedObjectNameFormatter qualifiedObjectNameFormatter;
    private final LobCreatorBuilderImpl lobCreatorBuilder;
    private final NameQualifierSupport nameQualifierSupport;

    public static boolean isMultiTenancyEnabled(ServiceRegistry serviceRegistry) {
        return serviceRegistry.getService(MultiTenantConnectionProvider.class) != null;
    }

    public JdbcEnvironmentImpl(ServiceRegistryImplementor serviceRegistry, Dialect dialect) {
        this.dialect = dialect;
        this.sqlAstTranslatorFactory = JdbcEnvironmentImpl.resolveSqlAstTranslatorFactory(dialect);
        ConfigurationService cfgService = JdbcEnvironmentImpl.configurationService(serviceRegistry);
        NameQualifierSupport dialectNameQualifierSupport = dialect.getNameQualifierSupport();
        this.nameQualifierSupport = dialectNameQualifierSupport == null ? NameQualifierSupport.BOTH : dialectNameQualifierSupport;
        this.sqlExceptionHelper = JdbcEnvironmentImpl.buildSqlExceptionHelper(dialect, JdbcEnvironmentImpl.logWarnings(cfgService, dialect), JdbcEnvironmentImpl.logErrors(cfgService));
        this.identifierHelper = JdbcEnvironmentImpl.identifierHelper(dialect, this.identifierHelperBuilder(cfgService, this.nameQualifierSupport));
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(this);
        this.currentCatalog = this.identifierHelper.toIdentifier(cfgService.getSetting("hibernate.default_catalog", StandardConverters.STRING));
        this.currentSchema = Identifier.toIdentifier(cfgService.getSetting("hibernate.default_schema", StandardConverters.STRING));
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl(this.nameQualifierSupport, dialect.getCatalogSeparator());
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder(dialect);
        JdbcEnvironmentImpl.logJdbcFetchSize(this.extractedMetaDataSupport.getDefaultFetchSize(), cfgService);
    }

    private static ConfigurationService configurationService(ServiceRegistryImplementor serviceRegistry) {
        return serviceRegistry.requireService(ConfigurationService.class);
    }

    private IdentifierHelperBuilder identifierHelperBuilder(ConfigurationService cfgService, NameQualifierSupport nameQualifierSupport) {
        IdentifierHelperBuilder builder = IdentifierHelperBuilder.from(this);
        builder.setGloballyQuoteIdentifiers(JdbcEnvironmentImpl.globalQuoting(cfgService));
        builder.setSkipGlobalQuotingForColumnDefinitions(JdbcEnvironmentImpl.globalQuotingSkippedForColumnDefinitions(cfgService));
        builder.setAutoQuoteKeywords(JdbcEnvironmentImpl.autoKeywordQuoting(cfgService));
        builder.setNameQualifierSupport(nameQualifierSupport);
        return builder;
    }

    private static IdentifierHelper identifierHelper(Dialect dialect, IdentifierHelperBuilder builder) {
        try {
            IdentifierHelper identifierHelper = dialect.buildIdentifierHelper(builder, null);
            if (identifierHelper != null) {
                return identifierHelper;
            }
        }
        catch (SQLException sqle) {
            log.debug((Object)"There was a problem accessing DatabaseMetaData in building the JdbcEnvironment", (Throwable)sqle);
        }
        return builder.build();
    }

    private static SqlAstTranslatorFactory resolveSqlAstTranslatorFactory(Dialect dialect) {
        SqlAstTranslatorFactory sqlAstTranslatorFactory = dialect.getSqlAstTranslatorFactory();
        return sqlAstTranslatorFactory == null ? new StandardSqlAstTranslatorFactory() : sqlAstTranslatorFactory;
    }

    private static boolean logWarnings(ConfigurationService cfgService, Dialect dialect) {
        return cfgService.getSetting("hibernate.jdbc.log.warnings", StandardConverters.BOOLEAN, Boolean.valueOf(dialect.isJdbcLogWarningsEnabledByDefault()));
    }

    private static boolean logErrors(ConfigurationService cfgService) {
        return cfgService.getSetting("hibernate.jdbc.log.errors", StandardConverters.BOOLEAN, Boolean.valueOf(true));
    }

    private static boolean globalQuoting(ConfigurationService cfgService) {
        return cfgService.getSetting("hibernate.globally_quoted_identifiers", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    private static boolean globalQuotingSkippedForColumnDefinitions(ConfigurationService cfgService) {
        return cfgService.getSetting("hibernate.globally_quoted_identifiers_skip_column_definitions", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    private static boolean autoKeywordQuoting(ConfigurationService cfgService) {
        return cfgService.getSetting("hibernate.auto_quote_keyword", StandardConverters.BOOLEAN, Boolean.valueOf(false));
    }

    public JdbcEnvironmentImpl(DatabaseMetaData databaseMetaData, Dialect dialect, JdbcConnectionAccess jdbcConnectionAccess) throws SQLException {
        this.dialect = dialect;
        this.sqlAstTranslatorFactory = JdbcEnvironmentImpl.resolveSqlAstTranslatorFactory(dialect);
        this.sqlExceptionHelper = JdbcEnvironmentImpl.buildSqlExceptionHelper(dialect, false, true);
        this.nameQualifierSupport = this.nameQualifierSupport(databaseMetaData, dialect);
        this.identifierHelper = this.identifierHelper(databaseMetaData, dialect);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(this, jdbcConnectionAccess, databaseMetaData);
        this.currentCatalog = null;
        this.currentSchema = null;
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl(this.nameQualifierSupport, databaseMetaData);
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder(dialect);
    }

    private IdentifierHelper identifierHelper(DatabaseMetaData databaseMetaData, Dialect dialect) {
        IdentifierHelperBuilder identifierHelperBuilder = IdentifierHelperBuilder.from(this);
        identifierHelperBuilder.setNameQualifierSupport(this.nameQualifierSupport);
        try {
            IdentifierHelper identifierHelper = dialect.buildIdentifierHelper(identifierHelperBuilder, databaseMetaData);
            if (identifierHelper != null) {
                return identifierHelper;
            }
        }
        catch (SQLException sqle) {
            log.debug((Object)"There was a problem accessing DatabaseMetaData in building the JdbcEnvironment", (Throwable)sqle);
        }
        return identifierHelperBuilder.build();
    }

    private NameQualifierSupport nameQualifierSupport(DatabaseMetaData databaseMetaData, Dialect dialect) throws SQLException {
        NameQualifierSupport nameQualifierSupport = dialect.getNameQualifierSupport();
        return nameQualifierSupport == null ? this.determineNameQualifierSupport(databaseMetaData) : nameQualifierSupport;
    }

    private NameQualifierSupport determineNameQualifierSupport(DatabaseMetaData databaseMetaData) throws SQLException {
        boolean supportsCatalogs = databaseMetaData.supportsCatalogsInTableDefinitions();
        boolean supportsSchemas = databaseMetaData.supportsSchemasInTableDefinitions();
        if (supportsCatalogs && supportsSchemas) {
            return NameQualifierSupport.BOTH;
        }
        if (supportsCatalogs) {
            return NameQualifierSupport.CATALOG;
        }
        if (supportsSchemas) {
            return NameQualifierSupport.SCHEMA;
        }
        return NameQualifierSupport.NONE;
    }

    @Deprecated
    public JdbcEnvironmentImpl(ServiceRegistryImplementor serviceRegistry, Dialect dialect, DatabaseMetaData databaseMetaData) {
        this(serviceRegistry, dialect);
    }

    public JdbcEnvironmentImpl(ServiceRegistryImplementor serviceRegistry, Dialect dialect, DatabaseMetaData databaseMetaData, JdbcConnectionAccess jdbcConnectionAccess) throws SQLException {
        this.dialect = dialect;
        this.sqlAstTranslatorFactory = JdbcEnvironmentImpl.resolveSqlAstTranslatorFactory(dialect);
        ConfigurationService cfgService = JdbcEnvironmentImpl.configurationService(serviceRegistry);
        this.sqlExceptionHelper = JdbcEnvironmentImpl.buildSqlExceptionHelper(dialect, JdbcEnvironmentImpl.logWarnings(cfgService, dialect), JdbcEnvironmentImpl.logErrors(cfgService));
        this.nameQualifierSupport = this.nameQualifierSupport(databaseMetaData, dialect);
        this.identifierHelper = this.identifierHelper(dialect, databaseMetaData, this.identifierHelperBuilder(cfgService, this.nameQualifierSupport));
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(this, jdbcConnectionAccess, databaseMetaData);
        this.currentCatalog = this.identifierHelper.toIdentifier(this.extractedMetaDataSupport.getConnectionCatalogName());
        this.currentSchema = this.identifierHelper.toIdentifier(this.extractedMetaDataSupport.getConnectionSchemaName());
        this.qualifiedObjectNameFormatter = new QualifiedObjectNameFormatterStandardImpl(this.nameQualifierSupport, databaseMetaData);
        this.lobCreatorBuilder = LobCreatorBuilderImpl.makeLobCreatorBuilder(dialect, cfgService.getSettings(), databaseMetaData.getConnection());
        JdbcEnvironmentImpl.logJdbcFetchSize(this.extractedMetaDataSupport.getDefaultFetchSize(), cfgService);
    }

    private IdentifierHelper identifierHelper(Dialect dialect, DatabaseMetaData databaseMetaData, IdentifierHelperBuilder builder) {
        try {
            IdentifierHelper identifierHelper = dialect.buildIdentifierHelper(builder, databaseMetaData);
            if (identifierHelper != null) {
                return identifierHelper;
            }
        }
        catch (SQLException sqle) {
            log.debug((Object)"There was a problem accessing DatabaseMetaData in building the JdbcEnvironment", (Throwable)sqle);
        }
        return builder.build();
    }

    private static SqlExceptionHelper buildSqlExceptionHelper(Dialect dialect, boolean logWarnings, boolean logErrors) {
        SQLExceptionConversionDelegate[] sQLExceptionConversionDelegateArray;
        SQLExceptionConversionDelegate dialectDelegate = dialect.buildSQLExceptionConversionDelegate();
        if (dialectDelegate == null) {
            SQLExceptionConversionDelegate[] sQLExceptionConversionDelegateArray2 = new SQLExceptionConversionDelegate[2];
            sQLExceptionConversionDelegateArray2[0] = new SQLExceptionTypeDelegate(dialect);
            sQLExceptionConversionDelegateArray = sQLExceptionConversionDelegateArray2;
            sQLExceptionConversionDelegateArray2[1] = new SQLStateConversionDelegate(dialect);
        } else {
            SQLExceptionConversionDelegate[] sQLExceptionConversionDelegateArray3 = new SQLExceptionConversionDelegate[3];
            sQLExceptionConversionDelegateArray3[0] = dialectDelegate;
            sQLExceptionConversionDelegateArray3[1] = new SQLExceptionTypeDelegate(dialect);
            sQLExceptionConversionDelegateArray = sQLExceptionConversionDelegateArray3;
            sQLExceptionConversionDelegateArray3[2] = new SQLStateConversionDelegate(dialect);
        }
        SQLExceptionConversionDelegate[] delegates = sQLExceptionConversionDelegateArray;
        return new SqlExceptionHelper(new StandardSQLExceptionConverter(delegates), logWarnings, logErrors);
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return this.sqlAstTranslatorFactory;
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedDatabaseMetaData() {
        return this.extractedMetaDataSupport;
    }

    @Override
    public Identifier getCurrentCatalog() {
        return this.currentCatalog;
    }

    @Override
    public Identifier getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    public QualifiedObjectNameFormatter getQualifiedObjectNameFormatter() {
        return this.qualifiedObjectNameFormatter;
    }

    @Override
    public IdentifierHelper getIdentifierHelper() {
        return this.identifierHelper;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return this.nameQualifierSupport;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public LobCreatorBuilder getLobCreatorBuilder() {
        return this.lobCreatorBuilder;
    }

    private static void logJdbcFetchSize(int defaultFetchSize, ConfigurationService cfgService) {
        if (!cfgService.getSettings().containsKey("hibernate.jdbc.fetch_size")) {
            if (defaultFetchSize > 0 && defaultFetchSize < 100) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.warnLowFetchSize(defaultFetchSize);
            } else {
                JdbcLogging.JDBC_MESSAGE_LOGGER.usingFetchSize(defaultFetchSize);
            }
        }
    }
}

