/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.component.Dumpable;

public interface ContentDecoder {
    default public void beforeDecoding(Response response) {
    }

    public RetainableByteBuffer decode(ByteBuffer var1);

    default public void afterDecoding(Response response) {
    }

    public static class Factories
    implements Iterable<Factory>,
    Dumpable {
        private final Map<String, Factory> factories = new LinkedHashMap<String, Factory>();
        private HttpField acceptEncodingField;

        public HttpField getAcceptEncodingField() {
            return this.acceptEncodingField;
        }

        @Override
        public Iterator<Factory> iterator() {
            return this.factories.values().iterator();
        }

        public void clear() {
            this.factories.clear();
            this.acceptEncodingField = null;
        }

        public Factory put(Factory factory) {
            Factory result = this.factories.put(factory.getEncoding(), factory);
            String value = String.join((CharSequence)",", this.factories.keySet());
            this.acceptEncodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, value);
            return result;
        }

        public String dump() {
            return Dumpable.dump((Dumpable)this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.factories});
        }
    }

    public static abstract class Factory {
        private final String encoding;

        protected Factory(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Factory)) {
                return false;
            }
            Factory that = (Factory)obj;
            return this.encoding.equals(that.encoding);
        }

        public int hashCode() {
            return this.encoding.hashCode();
        }

        public abstract ContentDecoder newContentDecoder();
    }
}

