/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

public class RocksDbSessionBytesStoreSupplier
implements SessionBytesStoreSupplier {
    private final String name;
    private final long retentionPeriod;

    public RocksDbSessionBytesStoreSupplier(String name, long retentionPeriod) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SessionStore<Bytes, byte[]> get() {
        RocksDBSegmentedBytesStore segmented = new RocksDBSegmentedBytesStore(this.name, this.metricsScope(), this.retentionPeriod, this.segmentIntervalMs(), new SessionKeySchema());
        return new RocksDBSessionStore(segmented);
    }

    @Override
    public String metricsScope() {
        return "rocksdb-session";
    }

    @Override
    public long segmentIntervalMs() {
        return Math.max(this.retentionPeriod / 2L, 60000L);
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

