# Define some data we will run our tests on
lorem = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."
so_many_as_array = repeat([0x61], 1000000)
so_many_as_tuple = ntuple((i) -> 0x61, 1000000)

data = Any[
    "",
    "test",
    lorem,
    IOBuffer(UInt8['\0']),
    repeat([0x00], SHA.blocklen(SHA.SHA3_512_CTX) - 1),
    so_many_as_array,
    so_many_as_tuple,
]

# Descriptions of the data, the SHA functions we'll run on the data, etc...
data_desc = [
    "the empty string",
    "the string \"test\"",
    "lorem ipsum",
    "0 file",
    "71 0's",
    "one million a's Array",
    "one million a's Tuple",
]
sha_types = Dict(sha1 => SHA.SHA1_CTX,
            sha2_224 => SHA.SHA2_224_CTX, sha2_256 => SHA.SHA2_256_CTX, sha2_384 => SHA.SHA2_384_CTX, sha2_512 => SHA.SHA2_512_CTX,
            sha2_512_224 => SHA.SHA2_512_224_CTX, sha2_512_256 => SHA.SHA2_512_256_CTX,
            sha3_224 => SHA.SHA3_224_CTX, sha3_256 => SHA.SHA3_256_CTX, sha3_384 => SHA.SHA3_384_CTX, sha3_512 => SHA.SHA3_512_CTX)
sha_funcs = [sha1,
             sha2_224, sha2_256, sha2_384, sha2_512,
             sha2_512_224, sha2_512_256,
             sha3_224, sha3_256, sha3_384, sha3_512]
ctxs = [SHA1_CTX,
        SHA2_224_CTX, SHA2_256_CTX, SHA2_384_CTX, SHA2_512_CTX,
        SHA2_512_224_CTX, SHA2_512_256_CTX,
        SHA3_224_CTX, SHA3_256_CTX, SHA3_384_CTX, SHA3_512_CTX]
shws = ["SHA1 hash state",
        "SHA2 224-bit hash state", "SHA2 256-bit hash state", "SHA2 384-bit hash state", "SHA2 512-bit hash state",
        "SHA2 512/224-bit hash state", "SHA2 512/256-bit hash state",
        "SHA3 224-bit hash state", "SHA3 256-bit hash state", "SHA3 384-bit hash state", "SHA3 512-bit hash state"]

answers = Dict(
    sha1 => [
        "da39a3ee5e6b4b0d3255bfef95601890afd80709",
        "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3",
        "19afa2a4a37462c7b940a6c4c61363d49c3a35f4",
        "5ba93c9db0cff93f52b521d7420e43f6eda2784f",
        "ae9c81906afe9cc485d6808c62a7e2fd227ac6c6",
        "34aa973cd4c4daa4f61eeb2bdbad27316534016f",
        "34aa973cd4c4daa4f61eeb2bdbad27316534016f"
    ],
    sha2_224 => [
        "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f",
        "90a3ed9e32b2aaf4c61c410eb925426119e1a9dc53d4286ade99a809",
        "6a0644abcf1e2cecbec2814443dab5f24b7ad8ebb66c75667ab67959",
        "fff9292b4201617bdc4d3053fce02734166a683d7d858a7f5f59b073",
        "3c76898e8f63d13ce03c37bfba507ac51f4f56422c5f4a049ed3a02c",
        "20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67",
        "20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67"
    ],
    sha2_256 => [
        "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855",
        "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08",
        "2c7c3d5f244f1a40069a32224215e0cf9b42485c99d80f357d76f006359c7a18",
        "6e340b9cffb37a989ca544e6bb780a2c78901d3fb33738768511a30617afa01d",
        "0805dcdc42ca47abdc3d8fe11f8e0c7a108602022f71ab349648cfdd30a75aa6",
        "cdc76e5c9914fb9281a1c7e284d73e67f1809a48a497200e046d39ccc7112cd0",
        "cdc76e5c9914fb9281a1c7e284d73e67f1809a48a497200e046d39ccc7112cd0"
    ],
    sha2_384 => [
        "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b",
        "768412320f7b0aa5812fce428dc4706b3cae50e02a64caa16a782249bfe8efc4b7ef1ccb126255d196047dfedf17a0a9",
        "63980fd0425cd2c3d8a400ee0f2671ef135db03b947ec1af21b6e28f19c16ca272036469541f4d8e336ac6d1da50580f",
        "bec021b4f368e3069134e012c2b4307083d3a9bdd206e24e5f0d86e13d6636655933ec2b413465966817a9c208a11717",
        "a1cc246f33d6117af295aa5c8554af5c320d5345fb5dfbf040ba6467abe999931bf3eab4c354bc9bf947a28da257793b",
        "9d0e1809716474cb086e834e310a4a1ced149e9c00f248527972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985",
        "9d0e1809716474cb086e834e310a4a1ced149e9c00f248527972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985"
    ],
    sha2_512 => [
        "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e",
        "ee26b0dd4af7e749aa1a8ee3c10ae9923f618980772e473f8819a5d4940e0db27ac185f8a0e1d5f84f88bc887fd67b143732c304cc5fa9ad8e6f57f50028a8ff",
        "f41d92bc9fc1157a0d1387e67f3d0893b70f7039d3d46d8115b5079d45ad601159398c79c281681e2da09bf7d9f8c23b41d1a0a3c5b528a7f2735933a4353194",
        "b8244d028981d693af7b456af8efa4cad63d282e19ff14942c246e50d9351d22704a802a71c3580b6370de4ceb293c324a8423342557d4e5c38438f0e36910ee",
        "e1403027c2f55d2dc4972b35b16e9401d0a9b5e055839e650b242fb12051051f72ef760214bf436ba9dd2b0d67daa2d55a783e782717d53966465b8c291acbfc",
        "e718483d0ce769644e2e42c7bc15b4638e1f98b13b2044285632a803afa973ebde0ff244877ea60a4cb0432ce577c31beb009c5c2c49aa2e4eadb217ad8cc09b",
        "e718483d0ce769644e2e42c7bc15b4638e1f98b13b2044285632a803afa973ebde0ff244877ea60a4cb0432ce577c31beb009c5c2c49aa2e4eadb217ad8cc09b"
    ],
    sha2_512_224 => [
        "6ed0dd02806fa89e25de060c19d3ac86cabb87d6a0ddd05c333b84f4",
        "06001bf08dfb17d2b54925116823be230e98b5c6c278303bc4909a8c",
        "3a312b004a593b706790a4a5b25309eb7c83efb85a4d1f0a8440e09e",
        "283bb59af7081ed08197227d8f65b9591ffe1155be43e9550e57f941",
        "248d0549a1c049cfa48a45c56ace68cbe5a4fbeb53c685cc87294f45",
        "37ab331d76f0d36de422bd0edeb22a28accd487b7a8453ae965dd287",
        "37ab331d76f0d36de422bd0edeb22a28accd487b7a8453ae965dd287"
    ],
    sha2_512_256 => [
        "c672b8d1ef56ed28ab87c3622c5114069bdd3ad7b8f9737498d0c01ecef0967a",
        "3d37fe58435e0d87323dee4a2c1b339ef954de63716ee79f5747f94d974f913f",
        "9423e3863ebb6f22b9464aeb873a39d757ef6b6a87c4bc55642f69052741fc43",
        "10baad1713566ac2333467bddb0597dec9066120dd72ac2dcb8394221dcbe43d",
        "ae78e496b5e14648d064c88ec6165782776a13078627200ea146bc79be48a578",
        "9a59a052930187a97038cae692f30708aa6491923ef5194394dc68d56c74fb21",
        "9a59a052930187a97038cae692f30708aa6491923ef5194394dc68d56c74fb21"
    ],

    sha3_224 => [
        "6b4e03423667dbb73b6e15454f0eb1abd4597f9a1b078e3f5b5a6bc7",
        "3797bf0afbbfca4a7bbba7602a2b552746876517a7f9b7ce2db0ae7b",
        "ea5395370949ad8c7d2ca3e7c045ef3306fe3a3f4740de452ef87a28",
        "bdd5167212d2dc69665f5a8875ab87f23d5ce7849132f56371a19096",
        "23d056090c76004dacc1e3825fc7249d0cf37444ed17952cf64ccb2f",
        "d69335b93325192e516a912e6d19a15cb51c6ed5c15243e7a7fd653c",
        "d69335b93325192e516a912e6d19a15cb51c6ed5c15243e7a7fd653c"
    ],
    sha3_256 => [
        "a7ffc6f8bf1ed76651c14756a061d662f580ff4de43b49fa82d80a4b80f8434a",
        "36f028580bb02cc8272a9a020f4200e346e276ae664e45ee80745574e2f5ab80",
        "8c8142d2ca964ab307ace567ddd5764f17ebb76eb8ff25543ab54c14fe2ab139",
        "5d53469f20fef4f8eab52b88044ede69c77a6a68a60728609fc4a65ff531e7d0",
        "c977561c52fd7401efef9f9e9c9aa00097f45b64ee1d9d5d750297f0825a2148",
        "5c8875ae474a3634ba4fd55ec85bffd661f32aca75c6d699d0cdcb6c115891c1",
        "5c8875ae474a3634ba4fd55ec85bffd661f32aca75c6d699d0cdcb6c115891c1",
    ],
    sha3_384 => [
        "0c63a75b845e4f7d01107d852e4c2485c51a50aaaa94fc61995e71bbee983a2ac3713831264adb47fb6bd1e058d5f004",
        "e516dabb23b6e30026863543282780a3ae0dccf05551cf0295178d7ff0f1b41eecb9db3ff219007c4e097260d58621bd",
        "eb9fbba3eb916a4efe384b3125f5d03ceb9c5c1b94431ac30fa86c54408b92701ca5d2628cd7113aa5541177ec3ccd1d",
        "127677f8b66725bbcb7c3eae9698351ca41e0eb6d66c784bd28dcdb3b5fb12d0c8e840342db03ad1ae180b92e3504933",
        "f76e941180b782cf014e49464d2522f08bdbfb71ac55356a6ed85ea6e498e15d4703a1c969b8e000f7b2ad00aa2d566b",
        "eee9e24d78c1855337983451df97c8ad9eedf256c6334f8e948d252d5e0e76847aa0774ddb90a842190d2c558b4b8340",
        "eee9e24d78c1855337983451df97c8ad9eedf256c6334f8e948d252d5e0e76847aa0774ddb90a842190d2c558b4b8340",
    ],
    sha3_512 => [
        "a69f73cca23a9ac5c8b567dc185a756e97c982164fe25859e0d1dcc1475c80a615b2123af1f5f94c11e3e9402c3ac558f500199d95b6d3e301758586281dcd26",
        "9ece086e9bac491fac5c1d1046ca11d737b92a2b2ebd93f005d7b710110c0a678288166e7fbe796883a4f2e9b3ca9f484f521d0ce464345cc1aec96779149c14",
        "3a4318353396a12dfd20442cfce1d8ad4d7e732e85cc56b01b4cf9057a41c8827c0a03c70812e76ace68d776759225c213b4f581aac0dba5dd43b785b1a33fe5",
        "7127aab211f82a18d06cf7578ff49d5089017944139aa60d8bee057811a15fb55a53887600a3eceba004de51105139f32506fe5b53e1913bfa6b32e716fe97da",
        "cd87417194c917561a59c7f2eb4b95145971e32e8e4ef3b23b0f190bfd29e3692cc7975275750a27df95d5c6a99b7a341e1b8a38a750a51aca5b77bae41fbbfc",
        "3c3a876da14034ab60627c077bb98f7e120a2a5370212dffb3385a18d4f38859ed311d0a9d5141ce9cc5c66ee689b266a8aa18ace8282a0e0db596c90b0a7b87",
        "3c3a876da14034ab60627c077bb98f7e120a2a5370212dffb3385a18d4f38859ed311d0a9d5141ce9cc5c66ee689b266a8aa18ace8282a0e0db596c90b0a7b87",
    ]
)

hmac_data = (
    ("", "", hmac_sha1, "fbdb1d1b18aa6c08324b7d64b71fb76370690e1d"),
    ("", "", hmac_sha256, "b613679a0814d9ec772f95d778c35fc5ff1697c493715653c6c712144292c5ad"),
    ("key", "The quick brown fox jumps over the lazy dog", hmac_sha1, "de7c9b85b8b78aa6bc8a7a36f70a90701c9db4d9"),
    ("key", "The quick brown fox jumps over the lazy dog", hmac_sha256, "f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8"),
)

# shake 128 testvectors
SHA128test = Dict([ ("d9e8",UInt(16)) => "c7211512340734235bb8d3c4651495aa",
                    ("3fc3dc539de2171e05909d1f89a6b01b302036f69c29756bea781b",UInt(16)) => "585739f75aaf8f980e7505e841981450",     
                    ("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",UInt(16))  => "82b41ecf981b19e4688f26f7ab366681",
                    ("2649ca7df44dbafbcc09f6378abd4e0e",UInt(134)) => "7bd949ee2ac44c91585467876835322986d8633f835c9e519b245cfa0c7674e960085079574f70b4329619a2986e2b49720a4c58510a0f00873ec0d37b4e25b6909d4515ce50a63de498ee3e7ddba3eded3fab5b765734705d90bb35f116828b2675b0478f61c84e9e4b3f2a1473c62f904879130d75862c4f290d3697e5345a7393b12ae411"])



# shake 256 testvectors
SHA256test = Dict([ ("0f",UInt(32)) => "aabb07488ff9edd05d6a603b7791b60a16d45093608f1badc0c9cc9a9154f215",
                    ("36c9970cbf6084743d076a68aa2039eb9061e1ff7a766467a9ee2fb10954aa74649c0ed7d4c277527ead3ab97d5978761d35f3154aca2107489e7f9fa45828616a24a67c98590895d35a34c659ba7fe737a37b0cbc78104e",UInt(32)) => "e6d737c11428a2b7e74de750839d0f1d90d91fa6045b6282f03508b40184ba78",  
                    ("6969a27ad5d0aae6479b2b044bb4b043642375ff503ccb538e17be2f1e41f6aa88b1db991ffefd6087cfb20875920192b671be8b7381f7e1b33d8ff5213429f110fe475cbc74b3ecd2211f9b33f308fcf536e0d0abc36bd5e7756adefddd7728093730ec339c97313179b9e40e3f8e2a2a5c21f5836bf0d632a7961239a6a7f77b44dc700cdd70d8abbfc90c8dde5bc45dcaca2380df4e",UInt(32)) => "bcdec7a8776380df27a4613cb50b7221995d3f752fa55691798ac2dfa0b15599",
                    ("74d7980949c1dc759a4a10acc3ab994b771ae6d8b5ef0005f8046233af610c36",UInt(2)) => "77cd",
                    ("6ae23f058f0f2264a18cd609acc26dd4dbc00f5c3ee9e13ecaea2bb5a2f0bb6b",UInt(190)) => "b9b92544fb25cfe4ec6fe437d8da2bbe00f7bdaface3de97b8775a44d753c3adca3f7c6f183cc8647e229070439aa9539ae1f8f13470c9d3527fffdeef6c94f9f0520ff0c1ba8b16e16014e1af43ac6d94cb7929188cce9d7b02f81a2746f52ba16988e5f6d93298d778dfe05ea0ef256ae3728643ce3e29c794a0370e9ca6a8bf3e7a41e86770676ac106f7ae79e67027ce7b7b38efe27d253a52b5cb54d6eb4367a87736ed48cb45ef27f42683da140ed3295dfc575d3ea38cfc2a3697",
                    ("e3ef127eadfafaf40408cebb28705df30b68d99dfa1893507ef3062d85461715",UInt(222)) => "7314002948c057006d4fc21e3e19c258fb5bdd57728fe93c9c6ef265b6d9f559ca73da32c427e135ba0db900d9003b19c9cf116f542a760418b1a435ac75ed5ab4ef151808c3849c3bce11c3cd285dd75e5c9fd0a0b32a89640a68e6e5b270f966f33911cfdffd03488b52b4c7fd1b2219de133e77519c426a63b9d8afac2ccab273ebd23765616b04446d6ac403f46ac0c147eda629eb7583c8bd00dc7c30fcd6711b36f99f80ac94b683ebb090581970ae7e696c4c0afa9b5dafe07d1ab80877cbd09b705a0147d62d72a506732459a54142a0892c56afb61359e910f1",
                    ("8d8001e2c096f1b88e7c9224a086efd4797fbf74a8033a2d422a2b6b8f6747e4",UInt(250)) => "2e975f6a8a14f0704d51b13667d8195c219f71e6345696c49fa4b9d08e9225d3d39393425152c97e71dd24601c11abcfa0f12f53c680bd3ae757b8134a9c10d429615869217fdd5885c4db174985703a6d6de94a667eac3023443a8337ae1bc601b76d7d38ec3c34463105f0d3949d78e562a039e4469548b609395de5a4fd43c46ca9fd6ee29ada5efc07d84d553249450dab4a49c483ded250c9338f85cd937ae66bb436f3b4026e859fda1ca571432f3bfc09e7c03ca4d183b741111ca0483d0edabc03feb23b17ee48e844ba2408d9dcfd0139d2e8c7310125aee801c61ab7900d1efc47c078281766f361c5e6111346235e1dc38325666c"])
