/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.HashMap;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public abstract class CloneInfo {
    protected final Map<Label, Label> labelRenameMap = new HashMap<Label, Label>();
    protected final Map<Variable, Variable> variableRenameMap = new HashMap<Variable, Variable>();
    protected final IRScope scope;

    protected CloneInfo(IRScope scope) {
        this.scope = scope;
    }

    public SimpleCloneInfo cloneForCloningClosure(IRClosure clonedClosure) {
        boolean ensureClone = this instanceof SimpleCloneInfo && ((SimpleCloneInfo)this).isEnsureBlockCloneMode();
        SimpleCloneInfo clone2 = new SimpleCloneInfo(clonedClosure, ensureClone);
        clone2.variableRenameMap.putAll(this.variableRenameMap);
        return clone2;
    }

    public IRScope getScope() {
        return this.scope;
    }

    protected abstract Label getRenamedLabelSimple(Label var1);

    public Label getRenamedLabel(Label label2) {
        if (Label.UNRESCUED_REGION_LABEL.equals(label2)) {
            return label2;
        }
        Label newLabel = this.labelRenameMap.get(label2);
        if (newLabel == null) {
            newLabel = this.getRenamedLabelSimple(label2);
            this.labelRenameMap.put(label2, newLabel);
        }
        return newLabel;
    }

    protected abstract Variable getRenamedSelfVariable(Variable var1);

    protected abstract Variable getRenamedVariableSimple(Variable var1);

    public Variable getRenamedVariable(Variable variable) {
        if (variable instanceof Self) {
            return this.getRenamedSelfVariable(variable);
        }
        Variable newVariable = this.variableRenameMap.get(variable);
        if (newVariable == null) {
            newVariable = this.getRenamedVariableSimple(variable);
            this.variableRenameMap.put(variable, newVariable);
        }
        return newVariable;
    }
}

