/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javajs.img.CRCEncoder;

public class PngEncoder
extends CRCEncoder {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    private static final int PT_FIRST_TAG = 37;
    private boolean encodeAlpha;
    private int filter = 0;
    private int bytesPerPixel;
    private int compressionLevel;
    private String type;
    private Integer transparentColor;
    private byte[] appData;
    private String appPrefix;
    private String comment;
    private byte[] bytes;
    private static final float inchesPerMeter = 39.37008f;
    private byte[] scanLines;
    private int byteWidth;

    @Override
    protected void setParams(Map<String, Object> params) {
        if (this.quality < 0) {
            this.quality = params.containsKey("qualityPNG") ? (Integer)params.get("qualityPNG") : 2;
        } else if (this.quality > 9 && this.quality < 90) {
            this.quality = 9;
        }
        this.dpi = 300;
        if (this.quality >= 90) {
            this.dpi = this.quality;
            this.quality = 2;
        }
        this.encodeAlpha = false;
        this.filter = 0;
        this.compressionLevel = this.quality;
        this.transparentColor = (Integer)params.get("transparentColor");
        this.comment = (String)params.get("comment");
        this.type = (params.get("type") + "0000").substring(0, 4);
        this.bytes = (byte[])params.get("pngImgData");
        this.appData = (byte[])params.get("pngAppData");
        this.appPrefix = (String)params.get("pngAppPrefix");
    }

    @Override
    protected void generate() throws IOException {
        if (this.bytes == null) {
            if (!this.pngEncode()) {
                this.out.cancel();
                return;
            }
            this.bytes = this.getBytes();
        } else {
            this.dataLen = this.bytes.length;
        }
        int len = this.dataLen;
        if (this.appData != null) {
            PngEncoder.setJmolTypeText(this.appPrefix, this.bytes, len, this.appData.length, this.type);
            this.out.write(this.bytes, 0, len);
            this.bytes = this.appData;
            len = this.appData.length;
        }
        this.out.write(this.bytes, 0, len);
    }

    private boolean pngEncode() {
        byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.writeBytes(pngIdBytes);
        this.writeHeader();
        this.writeText(PngEncoder.getApplicationText(this.appPrefix, this.type, 0, 0));
        this.writeText("Software\u0000Jmol " + this.comment);
        this.writeText("Creation Time\u0000" + this.date);
        if (this.dpi > 0) {
            this.writePhysicalSize();
        }
        if (!this.encodeAlpha && this.transparentColor != null) {
            this.writeTransparentColor(this.transparentColor);
        }
        return this.writeImageData();
    }

    private static void setJmolTypeText(String prefix, byte[] b, int nPNG, int nState, String type) {
        String s = "tEXt" + PngEncoder.getApplicationText(prefix, type, nPNG, nState);
        PngEncoder encoder = new PngEncoder();
        byte[] test = s.substring(0, 4 + prefix.length()).getBytes();
        int i = test.length;
        while (--i >= 0) {
            if (b[i + 37] == test[i]) continue;
            System.out.println("image is not of the right form; appending data, but not adding tEXt tag.");
            return;
        }
        encoder.setData(b, 37);
        encoder.writeString(s);
        encoder.writeCRC();
    }

    private static String getApplicationText(String prefix, String type, int nPNG, int nState) {
        String sPNG = "000000000" + nPNG;
        sPNG = sPNG.substring(sPNG.length() - 9);
        String sState = "000000000" + nState;
        sState = sState.substring(sState.length() - 9);
        return prefix + "\u0000" + type + (type.equals("PNG") ? "0" : "") + sPNG + "+" + sState;
    }

    private void writeHeader() {
        this.writeInt4(13);
        this.startPos = this.bytePos;
        this.writeString("IHDR");
        this.writeInt4(this.width);
        this.writeInt4(this.height);
        this.writeByte(8);
        this.writeByte(this.encodeAlpha ? 6 : 2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeCRC();
    }

    private void writeText(String msg) {
        this.writeInt4(msg.length());
        this.startPos = this.bytePos;
        this.writeString("tEXt" + msg);
        this.writeCRC();
    }

    private void writeTransparentColor(int icolor) {
        this.writeInt4(6);
        this.startPos = this.bytePos;
        this.writeString("tRNS");
        this.writeInt2(icolor >> 16 & 0xFF);
        this.writeInt2(icolor >> 8 & 0xFF);
        this.writeInt2(icolor & 0xFF);
        this.writeCRC();
    }

    private void writePhysicalSize() {
        this.writeInt4(9);
        this.writeString("pHYs");
        int ppm = Math.round(39.37008f * (float)this.dpi);
        this.writeInt4(ppm);
        this.writeInt4(ppm);
        this.writeByte(1);
        this.writeCRC();
    }

    private boolean writeImageData() {
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        this.byteWidth = this.width * this.bytesPerPixel;
        int scanWidth = this.byteWidth + 1;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, deflater);
        int pt = 0;
        try {
            int nRows;
            for (int rowsLeft = this.height; rowsLeft > 0; rowsLeft -= nRows) {
                nRows = Math.max(1, Math.min(Short.MAX_VALUE / scanWidth, rowsLeft));
                this.scanLines = new byte[scanWidth * nRows];
                int nPixels = this.width * nRows;
                int scanPos = 0;
                int i = 0;
                while (i < nPixels) {
                    if (i % this.width == 0) {
                        this.scanLines[scanPos++] = (byte)this.filter;
                    }
                    this.scanLines[scanPos++] = (byte)(this.pixels[pt] >> 16 & 0xFF);
                    this.scanLines[scanPos++] = (byte)(this.pixels[pt] >> 8 & 0xFF);
                    this.scanLines[scanPos++] = (byte)(this.pixels[pt] & 0xFF);
                    if (this.encodeAlpha) {
                        this.scanLines[scanPos++] = (byte)(this.pixels[pt] >> 24 & 0xFF);
                    }
                    ++i;
                    ++pt;
                }
                compBytes.write(this.scanLines, 0, scanPos);
            }
            compBytes.close();
            byte[] compressedLines = outBytes.toByteArray();
            this.writeInt4(compressedLines.length);
            this.startPos = this.bytePos;
            this.writeString("IDAT");
            this.writeBytes(compressedLines);
            this.writeCRC();
            this.writeEnd();
            deflater.finish();
            return true;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
    }

    private void writeEnd() {
        this.writeInt4(0);
        this.startPos = this.bytePos;
        this.writeString("IEND");
        this.writeCRC();
    }
}

