/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectJavaClassFinderKt;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClass;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaPackage;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectJavaClassFinder;", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/ClassLoader;)V", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findClasses", "", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "mayHaveAnnotations", "", "knownClassNamesInPackage", "", "", "packageFqName", "canComputeKnownClassNamesInPackage", "descriptors.runtime"})
public final class ReflectJavaClassFinder
implements JavaClassFinder {
    @NotNull
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClassId classId = request.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        String relativeClassName = StringsKt.replace$default((String)classId.getRelativeClassName().asString(), (char)'.', (char)'$', (boolean)false, (int)4, null);
        String name2 = packageFqName.isRoot() ? relativeClassName : packageFqName.asString() + '.' + relativeClassName;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name2);
        return klass != null ? (JavaClass)new ReflectJavaClass(klass) : null;
    }

    @Override
    @NotNull
    public List<JavaClass> findClasses(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return CollectionsKt.listOfNotNull((Object)this.findClass(request));
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName, boolean mayHaveAnnotations) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return new ReflectJavaPackage(fqName);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @Override
    public boolean canComputeKnownClassNamesInPackage() {
        return false;
    }
}

