/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.fileevents.internal;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLogger {
    static final Logger LOGGER = LoggerFactory.getLogger(NativeLogger.class);
    private static final List<LogLevel> logLevels = Arrays.asList(LogLevel.values());

    public static void log(int level, String message) {
        logLevels.get(level).getLogger().accept(message);
    }

    static enum LogLevel {
        TRACE(arg_0 -> ((Logger)LOGGER).trace(arg_0)),
        DEBUG(arg_0 -> ((Logger)LOGGER).debug(arg_0)),
        INFO(arg_0 -> ((Logger)LOGGER).info(arg_0)),
        WARN(arg_0 -> ((Logger)LOGGER).warn(arg_0)),
        ERROR(arg_0 -> ((Logger)LOGGER).error(arg_0));

        private final Consumer<String> logger;

        private LogLevel(Consumer<String> logger) {
            this.logger = logger;
        }

        Consumer<String> getLogger() {
            return this.logger;
        }
    }
}

