/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.gradle.api.internal.file.temp.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;

public abstract class FileTimeStampInspector {
    private final File workDir;
    private final File markerFile;
    private final TemporaryFileProvider temporaryFileProvider;
    private long lastBuildTimestamp;

    protected FileTimeStampInspector(File workDir) {
        this.workDir = workDir;
        this.markerFile = new File(workDir, "last-build.bin");
        this.temporaryFileProvider = new DefaultTemporaryFileProvider(() -> workDir);
    }

    public long getLastBuildTimestamp() {
        return this.lastBuildTimestamp;
    }

    protected void updateOnStartBuild() {
        this.workDir.mkdirs();
        this.lastBuildTimestamp = this.markerFile.exists() ? this.timestampOfMarkerFile() : 0L;
    }

    protected void updateOnFinishBuild() {
        this.workDir.mkdirs();
        try (FileOutputStream outputStream = new FileOutputStream(this.markerFile);){
            outputStream.write(0);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not update " + this.markerFile, e);
        }
        this.lastBuildTimestamp = this.timestampOfMarkerFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long currentTimestamp() {
        File file = this.temporaryFileProvider.createTemporaryFile("this-build", "bin", new String[0]);
        try {
            long l = this.timestampOf(file);
            return l;
        }
        finally {
            file.delete();
        }
    }

    public boolean timestampCanBeUsedToDetectFileChange(String file, long timestamp) {
        return timestamp != this.lastBuildTimestamp;
    }

    private long timestampOfMarkerFile() {
        return this.timestampOf(this.markerFile);
    }

    private long timestampOf(File file) {
        return Math.min(this.timestampFromFileOf(file), this.timestampViaNioOf(file));
    }

    private long timestampFromFileOf(File file) {
        return file.lastModified();
    }

    private long timestampViaNioOf(File file) {
        try {
            return Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

