/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.PointReference;
import tim.prune.cmd.RearrangePointsCmd;
import tim.prune.cmd.SetSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.SortMode;
import tim.prune.data.Track;
import tim.prune.function.RearrangeFunction;

public class RearrangePhotosFunction
extends RearrangeFunction {
    public RearrangePhotosFunction(App app) {
        super(app, false);
    }

    @Override
    public String getNameKey() {
        return "function.rearrangephotos";
    }

    @Override
    public String getDescriptionKey() {
        return "dialog.rearrangephotos.desc";
    }

    @Override
    protected String getSortNameKey() {
        return "sortbyfilename";
    }

    @Override
    protected void finish() {
        SortMode sortMode;
        RearrangeFunction.Rearrange rearrange = this.getRearrangeOption();
        List<PointReference> list = this.collectPhotoPoints(rearrange, sortMode = this.getSortMode());
        if (RearrangePhotosFunction.isResultANop(list)) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.rearrange.noop"), I18nManager.getText("error.function.noop.title"), 2);
        } else {
            SetSegmentsCmd setSegmentsCmd = new SetSegmentsCmd();
            Track track = this._app.getTrackInfo().getTrack();
            int n = track.getNumPoints();
            int n2 = 0;
            while (n2 < n) {
                DataPoint dataPoint = track.getPoint(n2);
                if (dataPoint.getPhoto() != null) {
                    setSegmentsCmd.addSegmentFlag(dataPoint);
                }
                ++n2;
            }
            CompoundCommand compoundCommand = new CompoundCommand().addCommand(RearrangePointsCmd.from(list)).addCommand(setSegmentsCmd);
            compoundCommand.setDescription(this.getName());
            compoundCommand.setConfirmText(I18nManager.getText("confirm.rearrangephotos"));
            this._app.execute(compoundCommand);
        }
    }

    private List<PointReference> collectPhotoPoints(RearrangeFunction.Rearrange rearrange, SortMode sortMode) {
        Track track = this._app.getTrackInfo().getTrack();
        int n = track.getNumPoints();
        ArrayList<PointReference> arrayList = new ArrayList<PointReference>();
        ArrayList<PointReference> arrayList2 = new ArrayList<PointReference>();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            if (dataPoint.getPhoto() != null) {
                PointReference pointReference = new PointReference(n2, sortMode == SortMode.SORTBY_NAME ? dataPoint.getPhoto().getName() : null, sortMode == SortMode.SORTBY_TIME ? dataPoint.getPhoto().getTimestamp() : null);
                arrayList.add(pointReference);
            } else {
                arrayList2.add(new PointReference(n2, null, null));
            }
            ++n2;
        }
        Collections.sort(arrayList);
        ArrayList<PointReference> arrayList3 = new ArrayList<PointReference>();
        if (rearrange == RearrangeFunction.Rearrange.TO_START) {
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
        } else {
            arrayList3.addAll(arrayList2);
            arrayList3.addAll(arrayList);
        }
        return arrayList3;
    }
}

