/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterGML
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader((Reader)this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start((ProgressTicket)this.progressTicket);
        ArrayList<Object> list = this.parseList(reader);
        boolean ret = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!"graph".equals(list.get(i)) || list.size() < i + 2 || !(list.get(i + 1) instanceof ArrayList)) continue;
            ret = this.parseGraph((ArrayList)list.get(i + 1));
        }
        if (!ret) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_badparsing"), Issue.Level.SEVERE));
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private ArrayList<Object> parseList(LineNumberReader reader) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        char t = ' ';
        boolean readString = false;
        Object stringBuffer = "";
        block10: while (reader.ready() && t != '\uffff') {
            t = (char)reader.read();
            if (readString) {
                if (t == '\"') {
                    list.add(stringBuffer);
                    stringBuffer = "";
                    readString = false;
                    continue;
                }
                stringBuffer = (String)stringBuffer + t;
                continue;
            }
            switch (t) {
                case '[': {
                    list.add(this.parseList(reader));
                    continue block10;
                }
                case ']': {
                    return list;
                }
                case '\"': {
                    readString = true;
                    continue block10;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    if (((String)stringBuffer).isEmpty()) continue block10;
                    try {
                        Long longValue = Long.valueOf((String)stringBuffer);
                        list.add(longValue);
                    }
                    catch (NumberFormatException e1) {
                        try {
                            Double doubleValue = Double.valueOf((String)stringBuffer);
                            list.add(doubleValue);
                        }
                        catch (NumberFormatException e2) {
                            list.add(stringBuffer);
                        }
                    }
                    stringBuffer = "";
                    continue block10;
                }
            }
            stringBuffer = (String)stringBuffer + t;
        }
        return list;
    }

    private boolean parseGraph(ArrayList list) {
        if ((list.size() & 1) != 0) {
            return false;
        }
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)list.size());
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            Object key = list.get(i);
            Object value = list.get(i + 1);
            if ("node".equals(key)) {
                ret = this.parseNode((ArrayList)value);
            } else if ("edge".equals(key)) {
                ret = this.parseEdge((ArrayList)value);
            } else if ("directed".equals(key)) {
                if (value instanceof Number) {
                    EdgeDirectionDefault edgeDefault = ((Number)value).intValue() == 1 ? EdgeDirectionDefault.DIRECTED : EdgeDirectionDefault.UNDIRECTED;
                    this.container.setEdgeDefault(edgeDefault);
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_directedgraphparse"), Issue.Level.WARNING));
                }
            }
            if (!ret || this.cancel) break;
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        return ret;
    }

    private boolean parseNode(ArrayList list) {
        String id = null;
        String label = null;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("id".equalsIgnoreCase(key)) {
                id = value.toString();
                continue;
            }
            if (!"label".equalsIgnoreCase(key)) continue;
            label = value.toString();
        }
        NodeDraft node = id != null ? this.container.factory().newNodeDraft(id) : this.container.factory().newNodeDraft();
        if (label != null) {
            node.setLabel(label);
        }
        if (id == null) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_nodeidmissing"), Issue.Level.WARNING));
        }
        boolean ret = this.addNodeAttributes(node, "", list);
        this.container.addNode(node);
        return ret;
    }

    private boolean addNodeAttributes(NodeDraft node, String prefix, ArrayList list) {
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("id".equalsIgnoreCase(key) || "label".equalsIgnoreCase(key)) continue;
            if (value instanceof ArrayList) {
                ret = this.addNodeAttributes(node, prefix + "." + key, (ArrayList)value);
                if (ret) continue;
                break;
            }
            if ("x".equalsIgnoreCase(key) && value instanceof Number) {
                node.setX(((Number)value).floatValue());
                continue;
            }
            if ("y".equalsIgnoreCase(key) && value instanceof Number) {
                node.setY(((Number)value).floatValue());
                continue;
            }
            if ("z".equalsIgnoreCase(key) && value instanceof Number) {
                node.setZ(((Number)value).floatValue());
                continue;
            }
            if ("w".equalsIgnoreCase(key) && value instanceof Number) {
                node.setSize(((Number)value).floatValue());
                continue;
            }
            if ("h".equalsIgnoreCase(key) || "d".equalsIgnoreCase(key)) continue;
            if ("fill".equalsIgnoreCase(key)) {
                if (value instanceof String) {
                    node.setColor((String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                node.setColor(new Color(((Number)value).intValue()));
                continue;
            }
            node.setValue(key, value);
        }
        return ret;
    }

    private boolean parseEdge(ArrayList list) {
        String id = null;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if (!"id".equalsIgnoreCase(key)) continue;
            id = value.toString();
        }
        EdgeDraft edgeDraft = id != null ? this.container.factory().newEdgeDraft(id) : this.container.factory().newEdgeDraft();
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("source".equals(key)) {
                NodeDraft source = this.container.getNode(value.toString());
                edgeDraft.setSource(source);
                continue;
            }
            if ("target".equals(key)) {
                NodeDraft target = this.container.getNode(value.toString());
                edgeDraft.setTarget(target);
                continue;
            }
            if ("value".equals(key) || "weight".equals(key)) {
                if (!(value instanceof Number)) continue;
                edgeDraft.setWeight(((Number)value).doubleValue());
                continue;
            }
            if (!"label".equals(key)) continue;
            edgeDraft.setLabel(value.toString());
        }
        boolean ret = this.addEdgeAttributes(edgeDraft, "", list);
        this.container.addEdge(edgeDraft);
        return ret;
    }

    private boolean addEdgeAttributes(EdgeDraft edge, String prefix, ArrayList list) {
        boolean ret = true;
        for (int i = 0; i < list.size(); i += 2) {
            String key = (String)list.get(i);
            Object value = list.get(i + 1);
            if ("id".equalsIgnoreCase(key) || "source".equalsIgnoreCase(key) || "target".equalsIgnoreCase(key) || "value".equalsIgnoreCase(key) || "weight".equalsIgnoreCase(key) || "label".equalsIgnoreCase(key)) continue;
            if (value instanceof ArrayList) {
                ret = this.addEdgeAttributes(edge, prefix + "." + key, (ArrayList)value);
                if (ret) continue;
                break;
            }
            if ("directed".equalsIgnoreCase(key)) {
                if (value instanceof Number) {
                    EdgeDirection type = ((Number)value).intValue() == 1 ? EdgeDirection.DIRECTED : EdgeDirection.UNDIRECTED;
                    edge.setDirection(type);
                    continue;
                }
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGML.class, (String)"importerGML_error_directedparse", (Object)edge.toString()), Issue.Level.WARNING));
                continue;
            }
            if ("fill".equalsIgnoreCase(key)) {
                if (value instanceof String) {
                    edge.setColor((String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                edge.setColor(new Color(((Number)value).intValue()));
                continue;
            }
            edge.setValue(key, value);
        }
        return ret;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

