/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncRequestProducer;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ClassicToAsyncAdaptor
extends CloseableHttpClient {
    private final CloseableHttpAsyncClient client;
    private final Timeout operationTimeout;

    public ClassicToAsyncAdaptor(CloseableHttpAsyncClient client, Timeout operationTimeout) {
        this.client = client;
        this.operationTimeout = operationTimeout;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        ClassicToAsyncRequestProducer requestProducer = new ClassicToAsyncRequestProducer(request, this.operationTimeout);
        ClassicToAsyncResponseConsumer responseConsumer = new ClassicToAsyncResponseConsumer(this.operationTimeout);
        Future<Void> resultFuture = this.client.execute(target, requestProducer, responseConsumer, null, context, null);
        if (request instanceof CancellableDependency) {
            ((CancellableDependency)request).setDependency(() -> resultFuture.cancel(true));
        }
        try {
            requestProducer.blockWaiting().execute();
            ClassicHttpResponse response = responseConsumer.blockWaiting();
            return CloseableHttpResponse.create(response, (closeable, closeMode) -> {
                try {
                    if (closeMode == CloseMode.GRACEFUL) {
                        closeable.close();
                    }
                }
                finally {
                    resultFuture.cancel(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    public void close() throws IOException {
        this.client.close();
    }

    public void close(CloseMode closeMode) {
        this.client.close(closeMode);
    }
}

