﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-autoscaling/ApplicationAutoScaling_EXPORTS.h>
#include <aws/application-autoscaling/model/Alarm.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationAutoScaling {
namespace Model {
class PutScalingPolicyResult {
 public:
  AWS_APPLICATIONAUTOSCALING_API PutScalingPolicyResult() = default;
  AWS_APPLICATIONAUTOSCALING_API PutScalingPolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONAUTOSCALING_API PutScalingPolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the resulting scaling policy.</p>
   */
  inline const Aws::String& GetPolicyARN() const { return m_policyARN; }
  template <typename PolicyARNT = Aws::String>
  void SetPolicyARN(PolicyARNT&& value) {
    m_policyARNHasBeenSet = true;
    m_policyARN = std::forward<PolicyARNT>(value);
  }
  template <typename PolicyARNT = Aws::String>
  PutScalingPolicyResult& WithPolicyARN(PolicyARNT&& value) {
    SetPolicyARN(std::forward<PolicyARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The CloudWatch alarms created for the target tracking scaling policy.</p>
   */
  inline const Aws::Vector<Alarm>& GetAlarms() const { return m_alarms; }
  template <typename AlarmsT = Aws::Vector<Alarm>>
  void SetAlarms(AlarmsT&& value) {
    m_alarmsHasBeenSet = true;
    m_alarms = std::forward<AlarmsT>(value);
  }
  template <typename AlarmsT = Aws::Vector<Alarm>>
  PutScalingPolicyResult& WithAlarms(AlarmsT&& value) {
    SetAlarms(std::forward<AlarmsT>(value));
    return *this;
  }
  template <typename AlarmsT = Alarm>
  PutScalingPolicyResult& AddAlarms(AlarmsT&& value) {
    m_alarmsHasBeenSet = true;
    m_alarms.emplace_back(std::forward<AlarmsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutScalingPolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyARN;

  Aws::Vector<Alarm> m_alarms;

  Aws::String m_requestId;
  bool m_policyARNHasBeenSet = false;
  bool m_alarmsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationAutoScaling
}  // namespace Aws
