/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class FloatCounter
extends PrimitiveCounter {
    private int size;
    private final int[] keys;
    private final int[] counts;

    public FloatCounter(int bufferSize) {
        bufferSize = bufferSize * 9 / 8;
        this.keys = new int[bufferSize];
        this.counts = new int[bufferSize];
    }

    public void count(float fkey) {
        int idx;
        int key = Float.floatToRawIntBits(fkey);
        int index = idx = this.hash(key);
        while (this.keys[index] != key && this.counts[index] != 0) {
            if ((index = this.incIndex(index)) != idx) continue;
            throw new RuntimeException("Full when counting " + fkey);
        }
        if (this.counts[index] == 0) {
            this.keys[index] = key;
            ++this.size;
        }
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Float.parseFloat(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(int key) {
        return Math.abs(key % this.keys.length);
    }

    private int incIndex(int index) {
        return ++index < this.keys.length ? index : 0;
    }

    public final class Iterator
    implements java.util.Iterator<Entry> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < FloatCounter.this.size;
        }

        @Override
        public Entry next() {
            Entry entry = new Entry();
            entry.count = FloatCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = FloatCounter.this.counts[++this.index];
            }
            entry.value = FloatCounter.this.keys[this.index++];
            ++this.count;
            return entry;
        }
    }

    public static final class Entry
    extends PrimitiveCounter.Record {
        private int value;
        private int count;

        private Entry() {
        }

        public float getPrimitive() {
            return Float.intBitsToFloat(this.value);
        }

        @Override
        public String getValue() {
            return Float.toString(this.getPrimitive());
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.value == ((Entry)o).value;
        }
    }
}

