/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.sunflow.PluginRegistry;
import org.sunflow.image.Bitmap;
import org.sunflow.image.BitmapReader;
import org.sunflow.image.Color;
import org.sunflow.image.formats.BitmapBlack;
import org.sunflow.math.MathUtils;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;
import org.sunflow.system.FileUtils;
import org.sunflow.system.UI;

public class Texture {
    private String filename;
    private boolean isLinear;
    private Bitmap bitmap;
    private int loaded;
    private boolean isTransparent;

    Texture(String string, boolean bl) {
        this.filename = string;
        this.isLinear = bl;
        this.loaded = 0;
    }

    private synchronized void load() {
        if (this.loaded != 0) {
            return;
        }
        String string = FileUtils.getExtension(this.filename);
        try {
            UI.printInfo(UI.Module.TEX, "Reading texture bitmap from: \"%s\" ...", this.filename);
            BitmapReader bitmapReader = PluginRegistry.bitmapReaderPlugins.createObject(string);
            if (bitmapReader == null) {
                try {
                    Object object;
                    URL uRL;
                    URL uRL2 = new URL(this.filename);
                    URLConnection uRLConnection = uRL2.openConnection();
                    if (uRLConnection instanceof JarURLConnection && (uRL = ((JarURLConnection)(object = (JarURLConnection)uRLConnection)).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
                        try {
                            if (new File(uRL.toURI()).canWrite()) {
                                uRLConnection.setUseCaches(false);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new IOException(uRISyntaxException);
                        }
                    }
                    object = uRLConnection.getInputStream();
                    int n = ((InputStream)object).read();
                    int n2 = ((InputStream)object).read();
                    ((InputStream)object).close();
                    bitmapReader = n == 255 && n2 == 216 ? PluginRegistry.bitmapReaderPlugins.createObject("jpg") : PluginRegistry.bitmapReaderPlugins.createObject("png");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bitmapReader != null) {
                this.bitmap = bitmapReader.load(this.filename, this.isLinear);
                if (this.bitmap.getWidth() == 0 || this.bitmap.getHeight() == 0) {
                    this.bitmap = null;
                }
            }
            block7: for (int i = 0; i < this.bitmap.getWidth(); ++i) {
                for (int j = 0; j < this.bitmap.getHeight(); ++j) {
                    if (!(this.bitmap.readAlpha(i, j) < 1.0f)) continue;
                    this.isTransparent = true;
                    continue block7;
                }
            }
            if (this.bitmap == null) {
                UI.printError(UI.Module.TEX, "Bitmap reading failed", new Object[0]);
                this.bitmap = new BitmapBlack();
            } else {
                UI.printDetailed(UI.Module.TEX, "Texture bitmap reading complete: %dx%d pixels found", this.bitmap.getWidth(), this.bitmap.getHeight());
            }
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.TEX, "%s", iOException.getMessage());
        }
        catch (BitmapReader.BitmapFormatException bitmapFormatException) {
            UI.printError(UI.Module.TEX, "%s format error: %s", string, bitmapFormatException.getMessage());
        }
        this.loaded = 1;
    }

    public Bitmap getBitmap() {
        if (this.loaded == 0) {
            this.load();
        }
        return this.bitmap;
    }

    public Color getPixel(float f, float f2) {
        Bitmap bitmap = this.getBitmap();
        f = MathUtils.frac(f);
        f2 = MathUtils.frac(f2);
        float f3 = f * (float)(bitmap.getWidth() - 1);
        float f4 = f2 * (float)(bitmap.getHeight() - 1);
        int n = (int)f3;
        int n2 = (int)f4;
        int n3 = (n + 1) % bitmap.getWidth();
        int n4 = (n2 + 1) % bitmap.getHeight();
        float f5 = f3 - (float)n;
        float f6 = f4 - (float)n2;
        f5 = f5 * f5 * (3.0f - 2.0f * f5);
        f6 = f6 * f6 * (3.0f - 2.0f * f6);
        float f7 = (1.0f - f5) * (1.0f - f6);
        Color color = bitmap.readColor(n, n2);
        float f8 = (1.0f - f5) * f6;
        Color color2 = bitmap.readColor(n, n4);
        float f9 = f5 * (1.0f - f6);
        Color color3 = bitmap.readColor(n3, n2);
        float f10 = f5 * f6;
        Color color4 = bitmap.readColor(n3, n4);
        Color color5 = Color.mul(f7, color);
        color5.madd(f8, color2);
        color5.madd(f9, color3);
        color5.madd(f10, color4);
        return color5;
    }

    public Color getOpacity(float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        Bitmap bitmap = this.getBitmap();
        f = MathUtils.frac(f);
        f2 = MathUtils.frac(f2);
        float f9 = f * (float)(bitmap.getWidth() - 1);
        float f10 = f2 * (float)(bitmap.getHeight() - 1);
        int n = (int)f9;
        int n2 = (int)f10;
        int n3 = (n + 1) % bitmap.getWidth();
        int n4 = (n2 + 1) % bitmap.getHeight();
        float f11 = f9 - (float)n;
        float f12 = f10 - (float)n2;
        float f13 = (1.0f - (f11 = f11 * f11 * (3.0f - 2.0f * f11))) * (1.0f - (f12 = f12 * f12 * (3.0f - 2.0f * f12)));
        float f14 = bitmap.readAlpha(n, n2);
        float f15 = f13 * f14 + (f8 = (1.0f - f11) * f12) * (f7 = bitmap.readAlpha(n, n4)) + (f6 = f11 * (1.0f - f12)) * (f5 = bitmap.readAlpha(n3, n2)) + (f4 = f11 * f12) * (f3 = bitmap.readAlpha(n3, n4));
        if ((double)f15 < 0.005) {
            return Color.BLACK;
        }
        if ((double)f15 > 0.995) {
            return Color.WHITE;
        }
        Color color = bitmap.readColor(n, n2).mul(1.0f - f14);
        Color color2 = bitmap.readColor(n, n4).mul(1.0f - f7);
        Color color3 = bitmap.readColor(n3, n2).mul(1.0f - f5);
        Color color4 = bitmap.readColor(n3, n4).mul(1.0f - f3);
        Color color5 = Color.mul(f13, color);
        color5.madd(f8, color2);
        color5.madd(f6, color3);
        color5.madd(f4, color4);
        return color5.opposite();
    }

    public float getOpacityAlpha(float f, float f2) {
        Bitmap bitmap = this.getBitmap();
        f = MathUtils.frac(f);
        f2 = MathUtils.frac(f2);
        float f3 = f * (float)(bitmap.getWidth() - 1);
        float f4 = f2 * (float)(bitmap.getHeight() - 1);
        int n = (int)f3;
        int n2 = (int)f4;
        int n3 = (n + 1) % bitmap.getWidth();
        int n4 = (n2 + 1) % bitmap.getHeight();
        float f5 = f3 - (float)n;
        float f6 = f4 - (float)n2;
        f5 = f5 * f5 * (3.0f - 2.0f * f5);
        f6 = f6 * f6 * (3.0f - 2.0f * f6);
        float f7 = (1.0f - f5) * (1.0f - f6);
        float f8 = bitmap.readAlpha(n, n2);
        float f9 = (1.0f - f5) * f6;
        float f10 = bitmap.readAlpha(n, n4);
        float f11 = f5 * (1.0f - f6);
        float f12 = bitmap.readAlpha(n3, n2);
        float f13 = f5 * f6;
        float f14 = bitmap.readAlpha(n3, n4);
        return f7 * f8 + f9 * f10 + f11 * f12 + f13 * f14;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public Vector3 getNormal(float f, float f2, OrthoNormalBasis orthoNormalBasis) {
        float[] fArray = this.getPixel(f, f2).getRGB();
        return orthoNormalBasis.transform(new Vector3(2.0f * fArray[0] - 1.0f, 2.0f * fArray[1] - 1.0f, 2.0f * fArray[2] - 1.0f)).normalize();
    }

    public Vector3 getBump(float f, float f2, OrthoNormalBasis orthoNormalBasis, float f3) {
        Bitmap bitmap = this.getBitmap();
        float f4 = 1.0f / (float)bitmap.getWidth();
        float f5 = 1.0f / (float)bitmap.getHeight();
        float f6 = this.getPixel(f, f2).getLuminance();
        float f7 = this.getPixel(f + f4, f2).getLuminance();
        float f8 = this.getPixel(f, f2 + f5).getLuminance();
        return orthoNormalBasis.transform(new Vector3(f3 * (f6 - f7), f3 * (f6 - f8), 1.0f)).normalize();
    }
}

