/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.api.ArrayBufferLibrary;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
public final class DirectBaseGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private DirectBaseGen() {
    }

    static {
        LibraryExport.register(JSArrayBufferObject.DirectBase.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new ArrayBufferLibraryExports()});
    }

    @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSArrayBufferObject.DirectBase.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSArrayBufferObject.DirectBase);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSArrayBufferObject.DirectBase);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
        public static class Uncached
        extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {
            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).hasBufferElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).getBufferSize();
            }

            @CompilerDirectives.TruffleBoundary
            public void readBuffer(Object receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBuffer(byteOffset, destination, destinationOffset, length);
            }

            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferByte(byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferShort(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferInt(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferLong(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferFloat(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferDouble(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).isBufferWritable();
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferByte(byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferShort(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferInt(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferLong(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferFloat(order, byteOffset, value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferDouble(order, byteOffset, value);
            }
        }

        @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
        public static class Cached
        extends JSNonProxyObjectGen.InteropLibraryExports.Cached {
            protected Cached(Object receiver) {
                super(receiver);
            }

            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).hasBufferElements();
            }

            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).getBufferSize();
            }

            public void readBuffer(Object receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBuffer(byteOffset, destination, destinationOffset, length);
            }

            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferByte(byteOffset);
            }

            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferShort(order, byteOffset);
            }

            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferInt(order, byteOffset);
            }

            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferLong(order, byteOffset);
            }

            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferFloat(order, byteOffset);
            }

            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).readBufferDouble(order, byteOffset);
            }

            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).isBufferWritable();
            }

            public void writeBufferByte(Object receiver, long byteOffset, byte value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferByte(byteOffset, value);
            }

            public void writeBufferShort(Object receiver, ByteOrder order, long byteOffset, short value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferShort(order, byteOffset, value);
            }

            public void writeBufferInt(Object receiver, ByteOrder order, long byteOffset, int value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferInt(order, byteOffset, value);
            }

            public void writeBufferLong(Object receiver, ByteOrder order, long byteOffset, long value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferLong(order, byteOffset, value);
            }

            public void writeBufferFloat(Object receiver, ByteOrder order, long byteOffset, float value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferFloat(order, byteOffset, value);
            }

            public void writeBufferDouble(Object receiver, ByteOrder order, long byteOffset, double value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((JSArrayBufferObject.DirectBase)((Object)receiver)).writeBufferDouble(order, byteOffset, value);
            }
        }
    }

    @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
    public static class ArrayBufferLibraryExports
    extends LibraryExport<ArrayBufferLibrary> {
        private ArrayBufferLibraryExports() {
            super(ArrayBufferLibrary.class, JSArrayBufferObject.DirectBase.class, false, false, 0);
        }

        protected ArrayBufferLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSArrayBufferObject.DirectBase);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ArrayBufferLibrary createCached(Object receiver) {
            assert (receiver instanceof JSArrayBufferObject.DirectBase);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
        public static class Uncached
        extends ArrayBufferLibrary
        implements UnadoptableNode {
            private final Class<? extends JSArrayBufferObject.DirectBase> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((JSArrayBufferObject.DirectBase)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).getContents();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)receiver)).libraryGetByteLength();
            }
        }

        @GeneratedBy(value=JSArrayBufferObject.DirectBase.class)
        public static class Cached
        extends ArrayBufferLibrary {
            private final Class<? extends JSArrayBufferObject.DirectBase> receiverClass_;

            protected Cached(Object receiver) {
                JSArrayBufferObject.DirectBase castReceiver = (JSArrayBufferObject.DirectBase)((Object)receiver);
                this.receiverClass_ = ((Object)((Object)castReceiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            public ByteBuffer getContents(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).getContents();
            }

            @Override
            public int getByteLength(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSArrayBufferObject.DirectBase)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).libraryGetByteLength();
            }
        }
    }
}

