/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyNumberFloatNode
extends PNodeWithContext {
    public abstract double execute(Frame var1, Node var2, Object var3);

    public final double execute(Node inliningTarget, Object object) {
        return this.execute(null, inliningTarget, object);
    }

    @Specialization
    static double doDouble(double object) {
        return object;
    }

    @Specialization
    static double doInt(int object) {
        return object;
    }

    @Specialization
    static double doLong(long object) {
        return object;
    }

    @Specialization
    static double doBoolean(boolean object) {
        return object ? 1.0 : 0.0;
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static double doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callFloat, @Cached PyNumberIndexNode indexNode, @Cached PyLongAsDoubleNode asDoubleNode, @Cached PyFloatAsDoubleNode.HandleFloatResultNode handleFloatResultNode, @Cached PyFloatFromString fromString) {
        Object type = getClassNode.execute(inliningTarget, object);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.nb_float() != null) {
            Object result = callFloat.execute(frame, inliningTarget, slots.nb_float(), object);
            if (result instanceof Double) {
                Double doubleResult = (Double)result;
                return doubleResult;
            }
            return PyFloatAsDoubleNode.handleFloatResult(frame, result, object, handleFloatResultNode);
        }
        if (slots.nb_index() != null) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            return asDoubleNode.execute(inliningTarget, index);
        }
        return fromString.execute((Frame)frame, inliningTarget, object);
    }
}

