\name{ShotNoiseImageFilter}
\alias{ShotNoiseImageFilter}
\title{ShotNoiseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Alter an image with shot noise.
ShotNoiseImageFilter}
\details{
The shot noise follows a Poisson distribution:
 \eqn{ I = N(I_0) }
where \eqn{ N(I_0) } is a Poisson-distributed random variable of mean \eqn{ I_0 } . The noise is thus dependent on the pixel intensities in the image.
 The intensities in the image can be scaled by a user provided value
to map pixel values to the actual number of particles. The scaling can
be seen as the inverse of the gain used during the acquisition. The
noisy signal is then scaled back to its input intensity range:
 \eqn{ I = \frac{N(I_0 \times s)}{s} }
where \eqn{ s } is the scale factor.
 The Poisson-distributed variable \eqn{ \lambda } is computed by using the algorithm:
 \eqn{  k \leftarrow 0 \\ p \leftarrow 1 \\ \textbf{repeat} \\ \left\{  k \leftarrow k+1 \\ p \leftarrow p \ast U()  \right. \\ \textbf{until } p > e^{\lambda} \\ \textbf{return} (k)  }
where \eqn{ U() } provides a uniformly distributed random variable in the interval \eqn{ [0,1] } .
 This algorithm is very inefficient for large values of \eqn{ \lambda } , though. Fortunately, the Poisson distribution can be accurately
approximated by a Gaussian distribution of mean and variance \eqn{ \lambda } when \eqn{ \lambda } is large enough. In this implementation, this value is considered to
be 50. This leads to the faster algorithm:
 \eqn{ \lambda + \sqrt{\lambda} \times N()}
where \eqn{ N() } is a normally distributed random variable of mean 0 and variance 1.
Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://www.insight-journal.org/browse/publication/721
See:
ShotNoise for the procedural interface
itk::ShotNoiseImageFilter for the Doxygen on the original ITK class.
ShotNoiseImageFilter}
%C++ includes: sitkShotNoiseImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetScale() const:}{
Set/Get the value to map the pixel value to the actual particle
counting. The scaling can be seen as the inverse of the gain used
during the acquisition. The noisy signal is then scaled back to its
input intensity range. Defaults to 1.0.
}
\item{uint32_t GetSeed() const:}{}
\item{Self SetScale(double Scale):}{
Set/Get the value to map the pixel value to the actual particle
counting. The scaling can be seen as the inverse of the gain used
during the acquisition. The noisy signal is then scaled back to its
input intensity range. Defaults to 1.0.
}
\item{Self SetSeed(uint32_t Seed):}{}
\item{ ShotNoiseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ShotNoiseImageFilter():}{
Destructor
}
}
}
