/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.semantics.ResolveResult;

public class RewriteInnerClassConstructorCalls
extends ContextTrackingVisitor<Void> {
    private final JavaResolver _resolver;

    public RewriteInnerClassConstructorCalls(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
        Expression firstArgument;
        ResolveResult resolvedArgument;
        super.visitObjectCreationExpression(node, data);
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (!arguments.isEmpty() && (resolvedArgument = this._resolver.apply(firstArgument = arguments.firstOrNullObject())) != null) {
            TypeDefinition resolvedCreatedType;
            TypeReference createdType = node.getType().getUserData(Keys.TYPE_REFERENCE);
            TypeReference argumentType = resolvedArgument.getType();
            if (createdType != null && argumentType != null && (resolvedCreatedType = createdType.resolve()) != null && resolvedCreatedType.isInnerClass() && !resolvedCreatedType.isStatic() && MetadataHelper.isEnclosedBy(resolvedCreatedType, argumentType)) {
                if (this.isContextWithinTypeInstance(argumentType) && firstArgument instanceof ThisReferenceExpression) {
                    MethodReference constructor = (MethodReference)node.getUserData(Keys.MEMBER_REFERENCE);
                    if (constructor != null && arguments.size() == constructor.getParameters().size()) {
                        firstArgument.remove();
                    }
                } else {
                    firstArgument.remove();
                    node.setTarget(firstArgument);
                    SimpleType type = new SimpleType(resolvedCreatedType.getSimpleName());
                    type.putUserData(Keys.TYPE_REFERENCE, resolvedCreatedType);
                    node.getType().replaceWith(type);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitSuperReferenceExpression(SuperReferenceExpression node, Void data) {
        Expression firstArgument;
        ResolveResult resolvedArgument;
        InvocationExpression parent;
        super.visitSuperReferenceExpression(node, data);
        if (node.getParent() instanceof InvocationExpression && !(parent = (InvocationExpression)node.getParent()).getArguments().isEmpty() && (resolvedArgument = this._resolver.apply(firstArgument = parent.getArguments().firstOrNullObject())) != null) {
            TypeDefinition resolvedSuperType;
            TypeReference superType = node.getUserData(Keys.TYPE_REFERENCE);
            TypeReference argumentType = resolvedArgument.getType();
            if (superType != null && argumentType != null && (resolvedSuperType = superType.resolve()) != null && resolvedSuperType.isInnerClass() && !resolvedSuperType.isStatic() && MetadataHelper.isEnclosedBy(this.context.getCurrentType(), argumentType)) {
                firstArgument.remove();
                if (!(firstArgument instanceof ThisReferenceExpression)) {
                    node.setTarget(firstArgument);
                }
            }
        }
        return null;
    }

    private boolean isContextWithinTypeInstance(TypeReference type) {
        TypeDefinition scope;
        MethodDefinition resolvedMethod;
        MethodDefinition method = this.context.getCurrentMethod();
        if (method != null && (resolvedMethod = method.resolve()) != null && resolvedMethod.isStatic()) {
            return false;
        }
        for (TypeReference current = scope = this.context.getCurrentType(); current != null; current = current.getDeclaringType()) {
            MethodDefinition resolvedDeclaringMethod;
            MethodReference declaringMethod;
            if (MetadataResolver.areEquivalent(current, type)) {
                return true;
            }
            TypeDefinition resolved = ((TypeReference)current).resolve();
            if (resolved != null && resolved.isLocalClass() && (declaringMethod = resolved.getDeclaringMethod()) != null && (resolvedDeclaringMethod = declaringMethod.resolve()) != null && resolvedDeclaringMethod.isStatic()) break;
        }
        return false;
    }
}

