/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import com.plantuml.ubrex.UMatcher;
import com.plantuml.ubrex.UnicodeBracketedExpression;
import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public abstract class UBrexCommandMultilines2<S extends Diagram>
implements Command<S> {
    private final UnicodeBracketedExpression starting;
    private final Trim trimEnd;
    private final MultilinesStrategy strategy;
    private final Lazy<UnicodeBracketedExpression> end;

    public UBrexCommandMultilines2(UnicodeBracketedExpression patternStart, MultilinesStrategy strategy, Trim trimEnd, Lazy<UnicodeBracketedExpression> end) {
        assert (end != null);
        this.strategy = strategy;
        this.starting = patternStart;
        this.trimEnd = trimEnd;
        this.end = end;
    }

    public boolean syntaxWithFinalBracket() {
        return false;
    }

    public final void getPatternEndToto() {
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        StringLocated first;
        lines = lines.cleanList(this.strategy);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        if (this.syntaxWithFinalBracket()) {
            if (lines.size() == 1 && !lines.getFirst().getTrimmed().getString().endsWith("{")) {
                String vline = lines.getAt(0).getString() + " {";
                if (this.isValid(BlocLines.singleString(vline)) == CommandControl.OK_PARTIAL) {
                    return CommandControl.OK_PARTIAL;
                }
                return CommandControl.NOT_OK;
            }
            lines = lines.eventuallyMoveBracket();
        }
        if ((first = lines.getFirst()) == null) {
            return CommandControl.NOT_OK;
        }
        UMatcher result1 = this.starting.match(first.getTrimmed().getString());
        if (!result1.exactMatch()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        UMatcher m1 = this.end.get().match(this.trimEnd.trim(lines.getLast()));
        if (!m1.exactMatch()) {
            return CommandControl.OK_PARTIAL;
        }
        return this.finalVerification(lines);
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines, ParserPass currentPass) {
        lines = lines.cleanList(this.strategy);
        if (this.syntaxWithFinalBracket()) {
            lines = lines.eventuallyMoveBracket();
        }
        try {
            return this.executeNow(system, lines, currentPass);
        }
        catch (NoSuchColorException e) {
            return CommandExecutionResult.badColor();
        }
    }

    protected abstract CommandExecutionResult executeNow(S var1, BlocLines var2, ParserPass var3) throws NoSuchColorException;

    protected boolean isCommandForbidden() {
        return false;
    }

    protected CommandControl finalVerification(BlocLines lines) {
        return CommandControl.OK;
    }

    protected final UnicodeBracketedExpression getStartingPattern() {
        return this.starting;
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return pass == ParserPass.ONE;
    }

    public UnicodeBracketedExpression getEndPattern() {
        return this.end.get();
    }
}

