/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.criteria;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class KeyAlgorithmCriterion
implements Criterion {
    @Nonnull
    private String keyAlgorithm;

    public KeyAlgorithmCriterion(@Nonnull @NotEmpty String algorithm) {
        this.keyAlgorithm = KeyAlgorithmCriterion.validateAlgorithm(algorithm);
    }

    @Nonnull
    @NotEmpty
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(@Nonnull String algorithm) {
        this.keyAlgorithm = KeyAlgorithmCriterion.validateAlgorithm(algorithm);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyAlgorithmCriterion [keyAlgorithm=");
        builder.append(this.keyAlgorithm);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyAlgorithm.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyAlgorithmCriterion) {
            KeyAlgorithmCriterion algcrit = (KeyAlgorithmCriterion)obj;
            return this.keyAlgorithm.equals(algcrit.keyAlgorithm);
        }
        return false;
    }

    @Nonnull
    @NotEmpty
    private static String validateAlgorithm(@Nonnull String algorithm) {
        String trimmed = StringSupport.trimOrNull(algorithm);
        return Constraint.isNotNull(trimmed, "Key algorithm criterion cannot be null or empty");
    }
}

