/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.protocolPB.InMemoryAliasMapProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMapProtocol;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.ipc.RPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryLevelDBAliasMapClient
extends BlockAliasMap<FileRegion>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryLevelDBAliasMapClient.class);
    private Configuration conf;
    private Collection<InMemoryAliasMapProtocol> aliasMaps = new ArrayList<InMemoryAliasMapProtocol>();

    @Override
    public void close() {
        if (this.aliasMaps != null) {
            for (InMemoryAliasMapProtocol aliasMap : this.aliasMaps) {
                RPC.stopProxy((Object)aliasMap);
            }
        }
    }

    InMemoryLevelDBAliasMapClient() {
    }

    private InMemoryAliasMapProtocol getAliasMap(String blockPoolID) throws IOException {
        if (blockPoolID == null) {
            throw new IOException("Block pool id required to get aliasmap reader");
        }
        for (InMemoryAliasMapProtocol aliasMap : this.aliasMaps) {
            try {
                String aliasMapBlockPoolId = aliasMap.getBlockPoolId();
                if (aliasMapBlockPoolId == null || !aliasMapBlockPoolId.equals(blockPoolID)) continue;
                return aliasMap;
            }
            catch (IOException e) {
                LOG.error("Exception in retrieving block pool id {}", (Throwable)e);
            }
        }
        throw new IOException("Unable to retrieve InMemoryAliasMap for block pool id " + blockPoolID);
    }

    @Override
    public BlockAliasMap.Reader<FileRegion> getReader(BlockAliasMap.Reader.Options opts, String blockPoolID) throws IOException {
        InMemoryAliasMapProtocol aliasMap = this.getAliasMap(blockPoolID);
        LOG.info("Loading InMemoryAliasMapReader for block pool id {}", (Object)blockPoolID);
        return new LevelDbReader(aliasMap);
    }

    @Override
    public BlockAliasMap.Writer<FileRegion> getWriter(BlockAliasMap.Writer.Options opts, String blockPoolID) throws IOException {
        InMemoryAliasMapProtocol aliasMap = this.getAliasMap(blockPoolID);
        LOG.info("Loading InMemoryAliasMapWriter for block pool id {}", (Object)blockPoolID);
        return new LevelDbWriter(aliasMap);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.aliasMaps = InMemoryAliasMapProtocolClientSideTranslatorPB.init(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() throws IOException {
    }

    static class LevelDbWriter
    extends BlockAliasMap.Writer<FileRegion> {
        private InMemoryAliasMapProtocol aliasMap;

        LevelDbWriter(InMemoryAliasMapProtocol aliasMap) {
            this.aliasMap = aliasMap;
        }

        @Override
        public void store(FileRegion fileRegion) throws IOException {
            this.aliasMap.write(fileRegion.getBlock(), fileRegion.getProvidedStorageLocation());
        }

        @Override
        public void close() throws IOException {
        }
    }

    class LevelDbReader
    extends BlockAliasMap.Reader<FileRegion> {
        private InMemoryAliasMapProtocol aliasMap;

        LevelDbReader(InMemoryAliasMapProtocol aliasMap) {
            this.aliasMap = aliasMap;
        }

        @Override
        public Optional<FileRegion> resolve(Block block) throws IOException {
            Optional<ProvidedStorageLocation> read = this.aliasMap.read(block);
            return read.map(psl -> new FileRegion(block, (ProvidedStorageLocation)psl));
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Iterator<FileRegion> iterator() {
            return new LevelDbIterator();
        }

        private class LevelDbIterator
        extends BlockAliasMap.ImmutableIterator {
            private Iterator<FileRegion> iterator;
            private Optional<Block> nextMarker;

            LevelDbIterator() {
                this.batch(Optional.empty());
            }

            private void batch(Optional<Block> newNextMarker) {
                try {
                    InMemoryAliasMapProtocol.IterationResult iterationResult = LevelDbReader.this.aliasMap.list(newNextMarker);
                    List<FileRegion> fileRegions = iterationResult.getFileRegions();
                    this.iterator = fileRegions.iterator();
                    this.nextMarker = iterationResult.getNextBlock();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || this.nextMarker.isPresent();
            }

            @Override
            public FileRegion next() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                if (this.nextMarker.isPresent()) {
                    this.batch(this.nextMarker);
                    return this.next();
                }
                throw new NoSuchElementException();
            }
        }
    }
}

