/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.deploy;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MLDeployModelNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    @Generated
    private static final Logger log = LogManager.getLogger(MLDeployModelNodeResponse.class);
    private Map<String, String> modelDeployStatus;

    public MLDeployModelNodeResponse(DiscoveryNode node, Map<String, String> modelDeployStatus) {
        super(node);
        this.modelDeployStatus = modelDeployStatus;
    }

    public MLDeployModelNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelDeployStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLDeployModelNodeResponse readStats(StreamInput in) throws IOException {
        return new MLDeployModelNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.modelDeployStatus != null && this.modelDeployStatus.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelDeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (this.modelDeployStatus != null && this.modelDeployStatus.size() > 0) {
            for (Map.Entry<String, String> stat : this.modelDeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }
}

