/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.GuidUtil;

public class SerialNumber
extends BasicObject {
    public int type;
    public UUID guid;
    public long value;

    public SerialNumber(UUID identifier, long value) {
        this.guid = identifier;
        this.value = value;
    }

    public SerialNumber(SerialNumber sn) {
        this.guid = sn.guid;
        this.value = sn.value;
    }

    public SerialNumber() {
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitWriter = null;
        if (this.guid.equals(GuidUtil.emptyGuid())) {
            bitWriter = new BitWriter(1);
            bitWriter.appendUInit32(0, 8);
        } else {
            bitWriter = new BitWriter(25);
            bitWriter.appendUInit32(128, 8);
            bitWriter.appendGUID(this.guid);
            bitWriter.appendUInt64(this.value, 64);
        }
        return bitWriter.getByteList();
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException {
        BitReader bitField = new BitReader(byteArray, startIndex);
        int type = bitField.readInt32(8);
        if (type == 0) {
            this.guid = GuidUtil.emptyGuid();
            this.type = 0;
            return 1;
        }
        if (type == 128) {
            this.guid = bitField.readGuid();
            this.value = bitField.readUInt64(64);
            this.type = 128;
            return 25;
        }
        throw new IllegalArgumentException("Failed to parse SerialNumber object, Expect the type value is either 0 or 128, but the actual value is " + this.type);
    }
}

