/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

public class PoolSizeTuner {
    static final String CLASS_NAME = PoolSizeTuner.class.getName();
    private static final boolean enabled = Util.isSelfTunerEnabled();
    private static long TUNEUP_TIMEOUT = 5000L;
    private static int TURN_RING_TIMEOUT = 5;
    private static long SINGLE_RUN_TIMEOUT = 600000L;
    private static final AtomicBoolean inProgress = new AtomicBoolean(false);
    private static volatile long giveUpTime = 0L;
    private static final AtomicBoolean tunedUp = new AtomicBoolean(false);
    private static final Set<Tunable> listTunable = new HashSet<Tunable>();
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock rLock = rwLock.readLock();
    private static final ReentrantReadWriteLock.WriteLock wLock = rwLock.writeLock();

    public static void trigger() {
        if (!enabled) {
            return;
        }
        giveUpTime = Clock.clock() + SINGLE_RUN_TIMEOUT;
        if (inProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(PoolSizeTuner.getTunerTask());
            }
            catch (RuntimeException e) {
                inProgress.set(false);
            }
        }
    }

    private static UCPTaskBase<Object> getTunerTask() {
        return new UCPTaskBase<Object>(){

            @Override
            public void run() {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "run", "started", null, null, new Object[0]);
                while (Clock.clock() < giveUpTime) {
                    for (int i = 0; i < TURN_RING_TIMEOUT; ++i) {
                        if (!Util.isSelfTunerEnabled()) {
                            return;
                        }
                        try {
                            Thread.sleep(TUNEUP_TIMEOUT);
                        }
                        catch (InterruptedException e) {
                            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "run", "", null, e, new Object[0]);
                        }
                        PoolSizeTuner.tuneUp();
                    }
                    PoolSizeTuner.turnRing();
                }
                inProgress.set(false);
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "run", "ended", null, null, new Object[0]);
            }
        };
    }

    private static void turnRing() {
        if (!enabled) {
            return;
        }
        rLock.lock();
        try {
            listTunable.forEach(p -> PoolSizeTuner.turnRing(p));
        }
        finally {
            rLock.unlock();
        }
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "turnRing", "ring turned", null, null, new Object[0]);
    }

    private static void turnRing(Tunable tunable) {
        if (!enabled) {
            return;
        }
        tunable.getAvailableRegistry().turnRing();
        tunable.getBorrowedRegistry().turnRing();
        tunable.getCreatedRegistry().turnRing();
    }

    private static void tuneUp() {
        if (!enabled) {
            return;
        }
        rLock.lock();
        try {
            listTunable.forEach(p -> PoolSizeTuner.tuneUp(p));
        }
        finally {
            rLock.unlock();
        }
    }

    private static void tuneUp(Tunable tunable) {
        if (!enabled) {
            return;
        }
        HistogramRegistry availableRegistry = tunable.getAvailableRegistry().collect();
        HistogramRegistry borrowedRegistry = tunable.getBorrowedRegistry().collect();
        HistogramRegistry createdRegistry = tunable.getCreatedRegistry().collect();
        availableRegistry.forEach((cri, availHist) -> PoolSizeTuner.tuneUp(cri, availHist, borrowedRegistry.getHistogram((ConnectionRetrievalInfo)cri), createdRegistry.getHistogram((ConnectionRetrievalInfo)cri), tunable));
    }

    private static void tuneUp(ConnectionRetrievalInfo cri, Histogram availHist, Histogram borrowHist, Histogram createHist, Tunable tunable) {
        if (!enabled) {
            return;
        }
        Pair<Long, Long> availER = availHist.computeEffectiveRange();
        Pair<Long, Long> borrowedER = borrowHist.computeEffectiveRange();
        Pair<Long, Long> createdER = createHist.computeEffectiveRange();
        boolean availGrowsInProgress = tunable.availableGrowsInProgress();
        int neverUsedConnCount = tunable.getNeverUsedConnectionsCounter().getCounter(cri).get();
        int totalConnsCount = tunable.getTotalConnectionsCount(cri);
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "tuneUp", "cri={0}, availER={1}, borrowedER={2}, createdER={3}, availGrowsInProgress={4}, neverUsedConnCount={5}, totalConnsCount={6}", null, null, cri, availER, borrowedER, createdER, availGrowsInProgress, neverUsedConnCount, totalConnsCount);
        if (availER.get1st() >= borrowedER.get1st() || availER.get2nd() > borrowedER.get2nd()) {
            long midAvail = availER.get2nd() + availER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToReduce = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midAvail - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToReduce) {
                tunable.getConnectionReducer().reduce(cri);
                ++i;
            }
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "tuneUp", "attempted to reduce {0} connection(s) for cri={1}", null, null, countToReduce, cri);
            tunedUp.set(true);
        } else if (!(availGrowsInProgress || 0 != neverUsedConnCount || createdER.get1st() <= borrowedER.get1st() && createdER.get2nd() <= borrowedER.get2nd())) {
            long midCreated = createdER.get2nd() + createdER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToGrow = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midCreated - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToGrow) {
                tunable.getConnectionGrower().grow(cri);
                ++i;
            }
            String msgGrow = "attempted to grow " + countToGrow + " connection(s) for CRI=" + cri;
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "tuneUp", "{0}", null, null, msgGrow);
            tunedUp.set(true);
        } else {
            tunedUp.set(false);
        }
    }

    private PoolSizeTuner() {
    }

    public static void plug(Tunable poolSizeTunerMetadata) {
        wLock.lock();
        try {
            listTunable.add(poolSizeTunerMetadata);
        }
        finally {
            wLock.unlock();
        }
    }

    public static void unplug(Tunable poolSizeTunerMetadata) {
        wLock.lock();
        try {
            listTunable.remove(poolSizeTunerMetadata);
        }
        finally {
            wLock.unlock();
        }
    }
}

