/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;

public final class IndonesianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public IndonesianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public IndonesianAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new LowerCaseFilter((TokenStream)source);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new IndonesianStemFilter((TokenStream)result));
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet((InputStream)((InputStream)IOUtils.requireResourceNonNull((Object)IndonesianAnalyzer.class.getResourceAsStream(IndonesianAnalyzer.DEFAULT_STOPWORD_FILE), (String)IndonesianAnalyzer.DEFAULT_STOPWORD_FILE)), (String)"#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

