/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.export;

import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import mediathek.config.Daten;
import mediathek.filmlisten.writer.FilmListWriter;
import mediathek.mainwindow.MediathekGui;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0014J\r\u0010\u0010\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/gui/actions/export/FilmlistExportWorker;", "Ljavax/swing/SwingWorker;", "", "", "exportAction", "Ljavax/swing/AbstractAction;", "selectedFile", "Ljava/io/File;", "compressSender", "compressThema", "<init>", "(Ljavax/swing/AbstractAction;Ljava/io/File;ZZ)V", "showError", "", "showSuccess", "done", "doInBackground", "()Ljava/lang/Boolean;", "MediathekView"})
public final class FilmlistExportWorker
extends SwingWorker<Boolean, Double> {
    @NotNull
    private final AbstractAction exportAction;
    @NotNull
    private final File selectedFile;
    private final boolean compressSender;
    private final boolean compressThema;

    public FilmlistExportWorker(@NotNull AbstractAction exportAction, @NotNull File selectedFile, boolean compressSender, boolean compressThema) {
        Intrinsics.checkNotNullParameter((Object)exportAction, (String)"exportAction");
        Intrinsics.checkNotNullParameter((Object)selectedFile, (String)"selectedFile");
        this.exportAction = exportAction;
        this.selectedFile = selectedFile;
        this.compressSender = compressSender;
        this.compressThema = compressThema;
    }

    private final void showError() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Es gab einen Fehler beim Export der Filmliste.", "MediathekView", 0);
    }

    private final void showSuccess() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Der Export wurde erfolgreich abgeschlossen.", "MediathekView", 1);
    }

    @Override
    protected void done() {
        try {
            Boolean result;
            Boolean bl = result = (Boolean)this.get();
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                this.showSuccess();
            } else {
                this.showError();
            }
        }
        catch (Exception exception) {
            this.showError();
        }
        this.exportAction.setEnabled(true);
    }

    @Override
    @NotNull
    protected Boolean doInBackground() throws Exception {
        FilmListWriter writer = new FilmListWriter(true);
        writer.setCompressSenderTag(this.compressSender);
        writer.setCompressThemaTag(this.compressThema);
        writer.setDecompressUrls(true);
        writer.writeFilmList(this.selectedFile.getAbsolutePath(), Daten.getInstance().getListeFilme(), arg_0 -> FilmlistExportWorker.doInBackground$lambda$0(this, arg_0));
        return true;
    }

    private static final void doInBackground$lambda$0(FilmlistExportWorker this$0, double prog) {
        this$0.setProgress(MathKt.roundToInt((double)(100.0 * prog)));
    }
}

