# `MD046` - Code block style

Tags: `code`

Aliases: `code-block-style`

Parameters:

- `style`: Block style (`string`, default `consistent`, values `consistent` /
  `fenced` / `indented`)

This rule is triggered when unwanted or different code block styles are used in
the same document.

In the default configuration this rule reports a violation for the following
document:

<!-- markdownlint-disable code-block-style -->

    Some text.

        # Indented code

    More text.

    ```ruby
    # Fenced code
    ```

    More text.

<!-- markdownlint-restore -->

To fix violations of this rule, use a consistent style (either indenting or code
fences).

The configured code block style can be specific (`fenced`, `indented`) or can
require all code blocks match the first code block (`consistent`).

Rationale: Consistent formatting makes it easier to understand a document.
