/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.text.MessageFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.resolve.multiplatform.K1ExpectActualMemberDiff;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/ExpectActualScopeDiffRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lorg/jetbrains/kotlin/resolve/multiplatform/K1ExpectActualMemberDiff;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "()V", "render", "", "obj", "renderingContext", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "frontend"})
public final class ExpectActualScopeDiffRenderer
implements DiagnosticParameterRenderer<K1ExpectActualMemberDiff<? extends CallableMemberDescriptor, ? extends ClassDescriptor>> {
    @NotNull
    public static final ExpectActualScopeDiffRenderer INSTANCE = new ExpectActualScopeDiffRenderer();

    private ExpectActualScopeDiffRenderer() {
    }

    @Override
    @NotNull
    public String render(@NotNull K1ExpectActualMemberDiff<? extends CallableMemberDescriptor, ? extends ClassDescriptor> obj, @NotNull RenderingContext renderingContext) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(renderingContext, "renderingContext");
        Object[] objectArray = new Object[]{Renderers.DECLARATION_NAME_WITH_KIND.render(obj.getActualMember(), renderingContext), Renderers.NAME.render(obj.getExpectClass())};
        String string = MessageFormat.format(obj.getKind().getRawMessage(), objectArray);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }
}

