/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.jdbc.provider.oson.OsonFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.type.format.jackson.JacksonIntegration;

public class OracleOsonJacksonHelper {
    public static final @Nullable Class<? extends Closeable> READER_CLASS = OracleOsonJacksonHelper.loadOrNull("com.fasterxml.jackson.core.JsonParser");
    public static final @Nullable Class<? extends Closeable> WRITER_CLASS = OracleOsonJacksonHelper.loadOrNull("com.fasterxml.jackson.core.JsonGenerator");

    private static @Nullable Class<? extends Closeable> loadOrNull(String name) {
        try {
            return JacksonIntegration.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }

    private OracleOsonJacksonHelper() {
    }

    public static Closeable createWriteTarget(OutputStream out) throws IOException {
        return FactoryHolder.JACKSON_FACTORY.createGenerator(out);
    }

    public static Closeable createReadSource(InputStream osonBytes) throws IOException {
        return FactoryHolder.JACKSON_FACTORY.createParser(osonBytes);
    }

    private static final class FactoryHolder {
        private static final JsonFactory JACKSON_FACTORY = JacksonIntegration.isJacksonOsonExtensionAvailable() ? new OsonFactory() : new JsonFactory();

        private FactoryHolder() {
        }
    }
}

