/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;

public class AdapterInstallationClientRegistrationProvider
implements ClientRegistrationProvider {
    private KeycloakSession session;
    private EventBuilder event;
    private ClientRegistrationAuth auth;

    public AdapterInstallationClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="clientId") String clientId) {
        this.event.event(EventType.CLIENT_INFO);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireView(client, true);
        ClientManager clientManager = new ClientManager(new RealmManager(this.session));
        ClientManager.InstallationAdapterConfig rep = clientManager.toInstallationRepresentation(this.session.getContext().getRealm(), client, this.session.getContext().getUri().getBaseUri());
        this.event.client(client.getClientId()).success();
        return Response.ok((Object)((Object)rep)).build();
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public ClientRegistrationAuth getAuth() {
        return this.auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public EventBuilder getEvent() {
        return this.event;
    }

    public void close() {
    }
}

