/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration.tracker;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.util.GlobUtil;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

@ConfigMapping(prefix="quarkus.config-tracking")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface ConfigTrackingConfig {
    @WithDefault(value="false")
    public boolean enabled();

    public Optional<Path> directory();

    public Optional<Path> file();

    @WithDefault(value="quarkus")
    public String filePrefix();

    @WithDefault(value="-config-dump")
    public String fileSuffix();

    public Optional<List<String>> exclude();

    default public List<Pattern> getExcludePatterns() {
        return ConfigTrackingConfig.toPatterns(this.exclude());
    }

    public Optional<List<String>> hashOptions();

    default public List<Pattern> getHashOptionsPatterns() {
        return ConfigTrackingConfig.toPatterns(this.hashOptions());
    }

    public static List<Pattern> toPatterns(Optional<List<String>> globs) {
        if (globs.isEmpty()) {
            return List.of();
        }
        List<String> list = globs.get();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(list.size());
        for (String s : list) {
            patterns.add(Pattern.compile(GlobUtil.toRegexPattern((String)s)));
        }
        return patterns;
    }

    @WithDefault(value="true")
    public boolean useUserHomeAliasInPaths();
}

