/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ImpersonationConstants {
    public static void setupMasterRealmRole(RealmProvider model, RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.getRole("admin");
        } else {
            adminRealm = model.getRealmByName(Config.getAdminRealm());
            adminRole = adminRealm.getRole("admin");
        }
        ClientModel realmAdminApp = adminRealm.getClientByClientId(KeycloakModelUtils.getMasterRealmAdminManagementClientId(realm.getName()));
        if (realmAdminApp.getRole("impersonation") != null) {
            return;
        }
        RoleModel impersonationRole = realmAdminApp.addRole("impersonation");
        impersonationRole.setDescription("${role_impersonation}");
        adminRole.addCompositeRole(impersonationRole);
    }

    public static void setupRealmRole(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminApplicationClientId = "realm-management";
        ClientModel realmAdminApp = realm.getClientByClientId(realmAdminApplicationClientId);
        if (realmAdminApp.getRole("impersonation") != null) {
            return;
        }
        RoleModel impersonationRole = realmAdminApp.addRole("impersonation");
        impersonationRole.setDescription("${role_impersonation}");
        RoleModel adminRole = realmAdminApp.getRole("realm-admin");
        adminRole.addCompositeRole(impersonationRole);
    }

    public static void setupImpersonationService(KeycloakSession session, RealmModel realm) {
        ImpersonationConstants.setupMasterRealmRole(session.realms(), realm);
        ImpersonationConstants.setupRealmRole(realm);
    }
}

