/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.YieldCompiler;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class NormalYieldCompiler
implements YieldCompiler {
    private final IRBytecodeAdapter compiler;

    public NormalYieldCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void yield(boolean unwrap) {
        this.compiler.adapter.ldc(unwrap);
        this.compiler.invokeIRHelper("yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject.class, Boolean.TYPE));
    }

    @Override
    public void yieldSpecific() {
        this.compiler.invokeIRHelper("yieldSpecific", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Block.class));
    }

    @Override
    public void yieldValues(int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("yield values has more than 250 arguments");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class, IRubyObject.class, arity2));
        String methodName = "yieldValues:" + arity2;
        ClassData classData = this.compiler.getClassData();
        if (!classData.arrayMethodsDefined.containsKey(arity2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.compiler.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.aload(1);
            IRBytecodeAdapter.buildArrayFromLocals(adapter2, 2, arity2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "yieldValues", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.arrayMethodsDefined.put(arity2, null);
        }
        this.compiler.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }
}

