/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.Windows8VectorTabControlIcon;

class WinFlatUtils {
    WinFlatUtils() {
    }

    static class HiDPIUtils {
        private HiDPIUtils() {
        }

        public static void paintAtScale1x(Graphics g0, int x, int y, int width, int height, HiDPIPainter painter) {
            Graphics2D g = (Graphics2D)g0;
            AffineTransform oldTransform = g.getTransform();
            g.translate(x, y);
            AffineTransform tx = g.getTransform();
            int txType = tx.getType();
            if (txType == 2 || txType == 3) {
                double scale = tx.getScaleX();
                int deviceX = (int)Math.round(tx.getTranslateX());
                int deviceY = (int)Math.ceil(tx.getTranslateY());
                int deviceXend = (int)Math.floor(tx.getTranslateX() + (double)width * scale);
                int deviceYend = (int)Math.floor(tx.getTranslateY() + (double)height * scale);
                int deviceWidth = deviceXend - deviceX;
                int deviceHeight = deviceYend - deviceY;
                g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, deviceX, deviceY));
                painter.paint(g, deviceWidth, deviceHeight, scale);
            } else {
                painter.paint(g, width, height, 1.0);
            }
            g.setTransform(oldTransform);
        }

        public static int deviceBorderWidth(double scale, int logical) {
            if (logical <= 0) {
                return 0;
            }
            return Math.max(1, (int)(scale * (double)logical));
        }
    }

    static interface HiDPIPainter {
        public void paint(Graphics2D var1, int var2, int var3, double var4);
    }

    static final class FlatTabControlIcon {
        FlatTabControlIcon() {
        }

        public static Icon get(int buttonId, int buttonState) {
            return Windows8VectorTabControlIcon.get(buttonId, buttonState);
        }
    }

    static final class UIScale {
        private UIScale() {
        }

        public static Insets scale(Insets insets) {
            return insets;
        }

        public static int scale(int value) {
            return value;
        }

        public static Dimension scale(Dimension value) {
            return value;
        }

        public static float getUserScaleFactor() {
            return 1.0f;
        }
    }

    static final class Utils {
        private Utils() {
        }

        static Color getUIColor(String key, Color defaultColor) {
            Color color = UIManager.getColor(key);
            return color != null ? color : defaultColor;
        }

        static Color getUIColor(String key, String defaultKey) {
            Color color = UIManager.getColor(key);
            return color != null ? color : UIManager.getColor(defaultKey);
        }

        static int getUIInt(String key, int defaultValue) {
            Object value = UIManager.get(key);
            return value instanceof Integer ? (Integer)value : defaultValue;
        }

        static boolean getUIBoolean(String key, boolean defaultValue) {
            Object value = UIManager.get(key);
            return value instanceof Boolean ? (Boolean)value : defaultValue;
        }
    }
}

