'''OpenGL extension OES.texture_float

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.texture_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	These extensions add texture formats with 16- (aka half float) and 32-bit
	floating-point components.  The 32-bit floating-point components
	are in the standard IEEE float format.  The 16-bit floating-point
	components have 1 sign bit, 5 exponent bits, and 10 mantissa bits.
	Floating-point components are clamped to the limits of the range
	representable by their format.
	
	The OES_texture_half_float extension string indicates that the
	implementation supports 16-bit floating pt texture formats.
	
	The OES_texture_float extension string indicates that the 
	implementation supports 32-bit floating pt texture formats.
	
	Both these extensions only require NEAREST magnification filter and 
	NEAREST, and NEAREST_MIPMAP_NEAREST minification filters to be supported.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/texture_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.texture_float import *
from OpenGL.raw.GLES2.OES.texture_float import _EXTENSION_NAME

def glInitTextureFloatOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION