/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader;

public class EncryptPathStructureOutput {
    private final List<CryptoItem> encryptedStructure;
    private final ParsedHeader parsedHeader;

    protected EncryptPathStructureOutput(BuilderImpl builder) {
        this.encryptedStructure = builder.encryptedStructure();
        this.parsedHeader = builder.parsedHeader();
    }

    public List<CryptoItem> encryptedStructure() {
        return this.encryptedStructure;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<CryptoItem> encryptedStructure;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptPathStructureOutput model) {
            this.encryptedStructure = model.encryptedStructure();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder encryptedStructure(List<CryptoItem> encryptedStructure) {
            this.encryptedStructure = encryptedStructure;
            return this;
        }

        @Override
        public List<CryptoItem> encryptedStructure() {
            return this.encryptedStructure;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public EncryptPathStructureOutput build() {
            if (Objects.isNull(this.encryptedStructure())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedStructure`");
            }
            if (Objects.isNull(this.parsedHeader())) {
                throw new IllegalArgumentException("Missing value for required field `parsedHeader`");
            }
            return new EncryptPathStructureOutput(this);
        }
    }

    public static interface Builder {
        public Builder encryptedStructure(List<CryptoItem> var1);

        public List<CryptoItem> encryptedStructure();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public EncryptPathStructureOutput build();
    }
}

