/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ltr.NodeStats;
import org.opensearch.client.opensearch.ltr.StoreStat;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LtrStatsResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, LtrStatsResponse> {
    @Nullable
    private final String clusterName;
    @Nonnull
    private final Map<String, NodeStats> nodes;
    @Nullable
    private final String status;
    @Nonnull
    private final Map<String, StoreStat> stores;
    public static final JsonpDeserializer<LtrStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LtrStatsResponse::setupLtrStatsResponseDeserializer);

    private LtrStatsResponse(Builder builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.status = builder.status;
        this.stores = ApiTypeHelper.unmodifiable(builder.stores);
    }

    public static LtrStatsResponse of(Function<Builder, ObjectBuilder<LtrStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final Map<String, NodeStats> nodes() {
        return this.nodes;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Nonnull
    public final Map<String, StoreStat> stores() {
        return this.stores;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, NodeStats> entry : this.nodes.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
        if (ApiTypeHelper.isDefined(this.stores)) {
            generator.writeKey("stores");
            generator.writeStartObject();
            for (Map.Entry<String, ToCopyableBuilder<NodeStats.Builder, NodeStats>> entry : this.stores.entrySet()) {
                generator.writeKey(entry.getKey());
                ((StoreStat)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLtrStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        LtrStatsResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeStats._DESERIALIZER), "nodes");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
        op.add(Builder::stores, JsonpDeserializer.stringMapDeserializer(StoreStat._DESERIALIZER), "stores");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.clusterName);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.status);
        result = 31 * result + Objects.hashCode(this.stores);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtrStatsResponse other = (LtrStatsResponse)o;
        return Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.status, other.status) && Objects.equals(this.stores, other.stores);
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LtrStatsResponse> {
        @Nullable
        private String clusterName;
        @Nullable
        private Map<String, NodeStats> nodes;
        @Nullable
        private String status;
        @Nullable
        private Map<String, StoreStat> stores;

        public Builder() {
        }

        private Builder(LtrStatsResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
            this.status = o.status;
            this.stores = Builder._mapCopy(o.stores);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.nodes = Builder._mapCopy(o.nodes);
            this.status = o.status;
            this.stores = Builder._mapCopy(o.stores);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(@Nullable String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeStats> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeStats value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeStats.Builder, ObjectBuilder<NodeStats>> fn) {
            return this.nodes(key, fn.apply(new NodeStats.Builder()).build());
        }

        @Nonnull
        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        @Nonnull
        public final Builder stores(Map<String, StoreStat> map) {
            this.stores = Builder._mapPutAll(this.stores, map);
            return this;
        }

        @Nonnull
        public final Builder stores(String key, StoreStat value) {
            this.stores = Builder._mapPut(this.stores, key, value);
            return this;
        }

        @Nonnull
        public final Builder stores(String key, Function<StoreStat.Builder, ObjectBuilder<StoreStat>> fn) {
            return this.stores(key, fn.apply(new StoreStat.Builder()).build());
        }

        @Override
        @Nonnull
        public LtrStatsResponse build() {
            this._checkSingleUse();
            return new LtrStatsResponse(this);
        }
    }
}

