/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ManagedPrefixList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedPrefixListResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateManagedPrefixListResponse> {
    private static final SdkField<ManagedPrefixList> PREFIX_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrefixList").getter(CreateManagedPrefixListResponse.getter(CreateManagedPrefixListResponse::prefixList)).setter(CreateManagedPrefixListResponse.setter(Builder::prefixList)).constructor(ManagedPrefixList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixList").unmarshallLocationName("prefixList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateManagedPrefixListResponse.memberNameToFieldInitializer();
    private final ManagedPrefixList prefixList;

    private CreateManagedPrefixListResponse(BuilderImpl builder) {
        super(builder);
        this.prefixList = builder.prefixList;
    }

    public final ManagedPrefixList prefixList() {
        return this.prefixList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedPrefixListResponse)) {
            return false;
        }
        CreateManagedPrefixListResponse other = (CreateManagedPrefixListResponse)((Object)obj);
        return Objects.equals(this.prefixList(), other.prefixList());
    }

    public final String toString() {
        return ToString.builder((String)"CreateManagedPrefixListResponse").add("PrefixList", (Object)this.prefixList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrefixList": {
                return Optional.ofNullable(clazz.cast(this.prefixList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ManagedPrefixList>> map = new HashMap<String, SdkField<ManagedPrefixList>>();
        map.put("PrefixList", PREFIX_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedPrefixListResponse, T> g) {
        return obj -> g.apply((CreateManagedPrefixListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private ManagedPrefixList prefixList;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedPrefixListResponse model) {
            super(model);
            this.prefixList(model.prefixList);
        }

        public final ManagedPrefixList.Builder getPrefixList() {
            return this.prefixList != null ? this.prefixList.toBuilder() : null;
        }

        public final void setPrefixList(ManagedPrefixList.BuilderImpl prefixList) {
            this.prefixList = prefixList != null ? prefixList.build() : null;
        }

        @Override
        public final Builder prefixList(ManagedPrefixList prefixList) {
            this.prefixList = prefixList;
            return this;
        }

        @Override
        public CreateManagedPrefixListResponse build() {
            return new CreateManagedPrefixListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateManagedPrefixListResponse> {
        public Builder prefixList(ManagedPrefixList var1);

        default public Builder prefixList(Consumer<ManagedPrefixList.Builder> prefixList) {
            return this.prefixList((ManagedPrefixList)((ManagedPrefixList.Builder)ManagedPrefixList.builder().applyMutation(prefixList)).build());
        }
    }
}

