/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.BooleanStack;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance(DefaultStubBuilder.class);

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            DefaultStubBuilder.$$$reportNull$$$0(0);
        }
        return this.buildStubTreeFor(file.getNode(), this.createStubForFile(file));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        PsiFileStubImpl<PsiFile> stub;
        if (file == null) {
            DefaultStubBuilder.$$$reportNull$$$0(1);
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            DefaultStubBuilder.$$$reportNull$$$0(2);
        }
        return psiFileStubImpl;
    }

    @NotNull
    protected final StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            DefaultStubBuilder.$$$reportNull$$$0(3);
        }
        if (parentStub == null) {
            DefaultStubBuilder.$$$reportNull$$$0(4);
        }
        new StubBuildingWalkingVisitor(root, parentStub).buildStubTree();
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            DefaultStubBuilder.$$$reportNull$$$0(5);
        }
        return stubElement;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        if (parent2 == null) {
            DefaultStubBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DefaultStubBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/DefaultStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStubTreeFor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTreeFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class StubBuildingWalkingVisitor {
        private final Stack<StubElement> parentStubs = new Stack();
        private final Stack<ASTNode> parentNodes = new Stack();
        private final BooleanStack parentNodesStubbed = new BooleanStack();

        protected StubBuildingWalkingVisitor(ASTNode root, StubElement parentStub) {
            this.parentNodes.push(root);
            this.parentStubs.push(parentStub);
            this.parentNodesStubbed.push(true);
        }

        public final void buildStubTree() {
            while (!this.parentStubs.isEmpty()) {
                this.visitNode(this.parentStubs.pop(), this.parentNodes.pop(), this.parentNodesStubbed.pop());
            }
        }

        protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
            StubElement stub = this.createStub(parentStub, node);
            if (stub != null && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            this.pushChildren(node, node instanceof FileElement || stub != null, stub != null ? stub : parentStub);
        }

        @Nullable
        protected final ASTNode peekNextElement() {
            return this.parentNodes.isEmpty() ? null : this.parentNodes.peek();
        }

        @Nullable
        protected StubElement createStub(StubElement parentStub, ASTNode node) {
            IStubElementType type;
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element + ", language: #" + type.getLanguage());
                }
                Object stub = type.createStub(element, parentStub);
                LOG.assertTrue(stub != null, element);
                return stub;
            }
            return null;
        }

        private void pushChildren(ASTNode node, boolean hasStub, StubElement stub) {
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (DefaultStubBuilder.this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                this.parentNodes.push(childNode);
                this.parentStubs.push(stub);
                this.parentNodesStubbed.push(hasStub);
            }
        }
    }
}

