/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.web.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.karaf.web.WebContainerService;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.model.info.WebApplicationInfo;
import org.ops4j.pax.web.service.spi.model.views.ReportWebContainerView;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerServiceImpl
implements WebContainerService {
    private BundleContext bundleContext;
    private WebContainer webContainer;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContainerServiceImpl.class);

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    @Override
    public List<WebApplicationInfo> list() throws Exception {
        if (this.webContainer == null) {
            return Collections.emptyList();
        }
        ReportWebContainerView view = (ReportWebContainerView)this.webContainer.adapt(ReportWebContainerView.class);
        if (view == null) {
            return Collections.emptyList();
        }
        Set webBundles = view.listWebApplications();
        return new ArrayList<WebApplicationInfo>(webBundles);
    }

    @Override
    public void install(String location, String contextPath) throws Exception {
        String completeLocation = "webbundle:" + location + "?Web-ContextPath=" + contextPath;
        Bundle bundle = this.bundleContext.installBundle(completeLocation);
        bundle.start();
    }

    @Override
    public void uninstall(List<Long> bundleIds) throws Exception {
        List<WebApplicationInfo> apps = this.list();
        HashMap<Long, Bundle> mapping = new HashMap<Long, Bundle>();
        for (WebApplicationInfo app : apps) {
            mapping.put(app.getBundle().getBundleId(), app.getBundle());
        }
        if (bundleIds != null && !bundleIds.isEmpty()) {
            Iterator<Object> iterator = bundleIds.iterator();
            while (iterator.hasNext()) {
                long bundleId = (Long)iterator.next();
                Bundle bundle = (Bundle)mapping.get(bundleId);
                if (bundle != null) {
                    bundle.uninstall();
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public void start(List<Long> bundleIds) throws Exception {
        if (bundleIds != null && !bundleIds.isEmpty()) {
            List<WebApplicationInfo> apps = this.list();
            HashMap<Long, Bundle> mapping = new HashMap<Long, Bundle>();
            for (WebApplicationInfo app : apps) {
                mapping.put(app.getBundle().getBundleId(), app.getBundle());
            }
            Iterator<Object> iterator = bundleIds.iterator();
            while (iterator.hasNext()) {
                long bundleId = (Long)iterator.next();
                Bundle bundle = (Bundle)mapping.get(bundleId);
                if (bundle != null) {
                    bundle.start();
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public void stop(List<Long> bundleIds) throws Exception {
        if (bundleIds != null && !bundleIds.isEmpty()) {
            List<WebApplicationInfo> apps = this.list();
            HashMap<Long, Bundle> mapping = new HashMap<Long, Bundle>();
            for (WebApplicationInfo app : apps) {
                mapping.put(app.getBundle().getBundleId(), app.getBundle());
            }
            Iterator<Object> iterator = bundleIds.iterator();
            while (iterator.hasNext()) {
                long bundleId = (Long)iterator.next();
                Bundle bundle = (Bundle)mapping.get(bundleId);
                if (bundle != null) {
                    bundle.stop();
                    continue;
                }
                System.out.println("Bundle ID " + bundleId + " is invalid");
                LOGGER.warn("Bundle ID {} is invalid", (Object)bundleId);
            }
        }
    }

    @Override
    public String state(long bundleId) throws Exception {
        List<WebApplicationInfo> apps = this.list();
        HashMap mapping = new HashMap();
        StringBuilder topic = new StringBuilder("Unknown    ");
        for (WebApplicationInfo app : apps) {
            if (bundleId != app.getBundle().getBundleId()) continue;
            topic = new StringBuilder(app.getDeploymentState());
        }
        while (topic.length() < 11) {
            topic.append(" ");
        }
        return topic.toString();
    }

    @Override
    public String getWebContextPath(Long id) throws Exception {
        List<WebApplicationInfo> apps = this.list();
        HashMap mapping = new HashMap();
        for (WebApplicationInfo app : apps) {
            if (id.longValue() != app.getBundle().getBundleId()) continue;
            return app.getContextPath();
        }
        return "";
    }
}

